/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.schedule;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.schedule.EmptyScheduleException;
import org.hyperic.util.schedule.ScheduleException;
import org.hyperic.util.schedule.ScheduledItem;
import org.hyperic.util.schedule.UnscheduledItemException;

public class Schedule {
    private final Object _lock = new Object();
    private long scheduleID = 0L;
    private Vector schedule;
    private Log log = LogFactory.getLog(Schedule.class);

    public Schedule() {
        this.schedule = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long consumeNextGlobalID() {
        Object object = this._lock;
        synchronized (object) {
            return this.scheduleID++;
        }
    }

    private void insertScheduledItem(ScheduledItem item) {
        int size = this.schedule.size();
        long nextTime = item.getNextTime();
        for (int i = 0; i < size; ++i) {
            ScheduledItem x = (ScheduledItem)this.schedule.get(i);
            if (x.getNextTime() <= nextTime) continue;
            this.schedule.add(i, item);
            return;
        }
        this.schedule.add(item);
    }

    public synchronized long scheduleItem(Object item, long interval, boolean prev, boolean repeat) throws ScheduleException {
        if (interval <= 0L) {
            throw new ScheduleException("Invalid schedule interval given (" + interval + ")");
        }
        long itemId = this.consumeNextGlobalID();
        ScheduledItem newItem = new ScheduledItem(item, interval, prev, repeat, itemId);
        this.insertScheduledItem(newItem);
        return itemId;
    }

    public synchronized long scheduleItem(Object item, long interval, boolean repeat) throws ScheduleException {
        return this.scheduleItem(item, interval, false, repeat);
    }

    public long scheduleItem(Object item, long interval) throws ScheduleException {
        return this.scheduleItem(item, interval, true);
    }

    public synchronized ScheduledItem unscheduleItem(long id) throws UnscheduledItemException {
        int size = this.schedule.size();
        for (int i = 0; i < size; ++i) {
            ScheduledItem item = (ScheduledItem)this.schedule.get(i);
            if (item.getId() != id) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unscheduling " + item.getObj() + " getNextTime " + Schedule.getDateStr(item.getNextTime())));
            }
            return (ScheduledItem)this.schedule.remove(i);
        }
        throw new UnscheduledItemException("id '" + id + "' not found");
    }

    public synchronized long getTimeOfNext() throws EmptyScheduleException {
        int size = this.schedule.size();
        if (size == 0) {
            throw new EmptyScheduleException();
        }
        ScheduledItem item = (ScheduledItem)this.schedule.get(0);
        return item.getNextTime();
    }

    public synchronized List consumeNextItems() throws EmptyScheduleException {
        ScheduledItem other;
        int i;
        int size = this.schedule.size();
        if (size == 0) {
            throw new EmptyScheduleException();
        }
        ArrayList<Object> res = new ArrayList<Object>(1);
        ScheduledItem base = (ScheduledItem)this.schedule.get(0);
        long baseNextTime = System.currentTimeMillis();
        res.add(base);
        boolean debug = this.log.isDebugEnabled();
        for (i = 1; i < size; ++i) {
            other = (ScheduledItem)this.schedule.get(i);
            if (debug) {
                this.log.debug((Object)("checking " + other.getObj() + " baseNextTime: " + Schedule.getDateStr(baseNextTime) + ", getNextTime: " + Schedule.getDateStr(other.getNextTime())));
            }
            if (other.getNextTime() > baseNextTime) break;
            res.add(other);
        }
        for (i = 0; i < res.size(); ++i) {
            other = (ScheduledItem)res.get(i);
            if (debug) {
                this.log.debug((Object)("removing " + other.getObj()));
            }
            this.schedule.remove(other);
            if (other.isRepeat()) {
                other.stepNextTime();
                if (debug) {
                    this.log.debug((Object)("adding " + other.getObj() + " getNextTime " + Schedule.getDateStr(other.getNextTime())));
                }
                this.insertScheduledItem(other);
            }
            res.set(i, other.getObj());
        }
        return res;
    }

    private static String getDateStr(long timems) {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(timems));
    }

    public int getNumItems() {
        return this.schedule.size();
    }

    public ScheduledItem[] getScheduledItems() {
        return this.schedule.toArray(new ScheduledItem[0]);
    }

    public static void main(String[] args) throws Exception {
        Schedule s = new Schedule();
        s.scheduleItem(new Integer(30), 30000L, true);
        s.scheduleItem(new Integer(5), 5000L, true);
        long id_for_8 = s.scheduleItem(new Integer(8), 8000L, true);
        s.scheduleItem(new Integer(10), 10000L, false);
        int secondsRunning = 0;
        while (true) {
            System.out.println(System.currentTimeMillis() / 1000L);
            if (System.currentTimeMillis() > s.getTimeOfNext()) {
                List items = s.consumeNextItems();
                System.out.println("Consuming");
                for (int i = 0; i < items.size(); ++i) {
                    System.out.println("Consumed: " + (Integer)items.get(i));
                }
            }
            Thread.sleep(1000L);
            if (++secondsRunning > 10 && id_for_8 != -1L) {
                s.unscheduleItem(id_for_8);
                System.out.println("Removing 8");
                id_for_8 = -1L;
            }
            if (secondsRunning <= 20) continue;
            System.exit(0);
        }
    }
}

