/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.encoding.Base64;

public class MD5 {
    private static final Log log = LogFactory.getLog(MD5.class);
    private MessageDigest md;

    public MD5() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find MD5 Algorithm");
        }
    }

    public void add(InputStream is) throws IOException {
        byte[] bytes = new byte[1024];
        try {
            int len;
            while ((len = is.read(bytes, 0, bytes.length)) != -1) {
                this.md.update(bytes, 0, len);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read data stream: " + e.getMessage());
        }
    }

    public void add(String input) {
        this.add(input.getBytes());
    }

    public void add(byte[] input) {
        this.md.update(input);
    }

    public byte[] getDigest() throws IOException {
        return this.md.digest();
    }

    public String getDigestString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int hi = bytes[i] >> 4 & 0xF;
            int lo = bytes[i] & 0xF;
            sb.append(Character.forDigit(hi, 16));
            sb.append(Character.forDigit(lo, 16));
        }
        return sb.toString();
    }

    public String getDigestString() throws IOException {
        return this.getDigestString(this.getDigest());
    }

    public static byte[] getDigest(String input) throws IOException {
        MD5 md5 = new MD5();
        md5.add(input);
        return md5.getDigest();
    }

    public static String getEncodedDigest(String input) throws IOException {
        return Base64.encode(MD5.getDigest(input));
    }

    public static String getDigestString(InputStream is) throws IOException {
        MD5 md5 = new MD5();
        md5.add(is);
        return md5.getDigestString();
    }

    public static String getDigestString(File file) throws IOException, FileNotFoundException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = new String(MD5.getDigestString(is));
            return string;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(" couldn't find file " + file + ": " + e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String getMD5Checksum(String buf) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buf.getBytes());
        return MD5.getMD5Checksum(stream);
    }

    public static String getMD5Checksum(File file) {
        try {
            FileInputStream fin = new FileInputStream(file);
            return MD5.getMD5Checksum(fin);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static String getMD5Checksum(InputStream fin) {
        try {
            int read;
            MessageDigest md5er = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            do {
                if ((read = fin.read(buffer)) <= 0) continue;
                md5er.update(buffer, 0, read);
            } while (read != -1);
            fin.close();
            byte[] digest = md5er.digest();
            if (digest == null) {
                return null;
            }
            StringBuilder strDigest = new StringBuilder();
            byte[] arr$ = digest;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Byte b = arr$[i$];
                strDigest.append(Integer.toString((b & 0xFF) + 256, 16).substring(1).toLowerCase());
            }
            return strDigest.toString();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

