/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.measurement.data.TrackEventReport;
import org.hyperic.hq.product.ConfigTrackPluginManager;
import org.hyperic.hq.product.LogTrackPluginManager;
import org.hyperic.hq.product.TrackEvent;

class TrackerThread
implements Runnable {
    private static final String PROP_MAXEVENTBATCHSIZE = "agent.eventReportBatchSize";
    private static final int MAX_EVENT_BATCHSIZE = 100;
    private static final String CONFIGTRACK_LISTNAME = "configtrack_spool";
    private static final String LOGTRACK_LISTNAME = "logtrack_spool";
    private static final int LOGTRACK_RECSIZE = 5120;
    private volatile boolean shouldDie;
    private volatile Thread myThread;
    private Object interrupter;
    private long waitTime;
    private int maxEventBatchSize = 100;
    private AgentStorageProvider storage;
    private MeasurementCallbackClient client;
    private ConfigTrackPluginManager ctManager;
    private LogTrackPluginManager ltManager;
    private Log log;

    TrackerThread(ConfigTrackPluginManager ctManager, LogTrackPluginManager ltManager, AgentStorageProvider storage, Properties bootProps) throws AgentStartException {
        this.ctManager = ctManager;
        this.ltManager = ltManager;
        this.storage = storage;
        this.shouldDie = false;
        this.myThread = null;
        this.interrupter = new Object();
        this.client = this.setupClient();
        this.waitTime = 60000L;
        this.log = LogFactory.getLog(TrackerThread.class);
        String info = bootProps.getProperty(CONFIGTRACK_LISTNAME);
        if (info != null) {
            storage.addOverloadedInfo(CONFIGTRACK_LISTNAME, info);
        }
        if ((info = bootProps.getProperty(LOGTRACK_LISTNAME)) != null) {
            storage.addOverloadedInfo(LOGTRACK_LISTNAME, info);
        }
        try {
            this.storage.createList(LOGTRACK_LISTNAME, 5120);
        }
        catch (AgentStorageException ignore) {
            // empty catch block
        }
        String sMaxBatchSize = bootProps.getProperty(PROP_MAXEVENTBATCHSIZE);
        if (sMaxBatchSize != null) {
            try {
                this.maxEventBatchSize = Integer.parseInt(sMaxBatchSize);
            }
            catch (NumberFormatException exc) {
                throw new AgentStartException("agent.eventReportBatchSize is not a valid integer ('" + sMaxBatchSize + "')");
            }
        }
        this.log.info((Object)("Event report batch size set to " + this.maxEventBatchSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptMe() {
        Object object = this.interrupter;
        synchronized (object) {
            this.interrupter.notify();
        }
    }

    private MeasurementCallbackClient setupClient() throws AgentStartException {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this.storage);
        return new MeasurementCallbackClient((ProviderFetcher)fetcher);
    }

    private void flushEvents(LinkedList events, String dListName) {
        if (events.isEmpty()) {
            return;
        }
        for (TrackEvent event : events) {
            try {
                String data = event.encode();
                this.storage.addToList(dListName, data);
                this.log.debug((Object)("Stored event (" + data.length() + " bytes) " + event));
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to store data", (Throwable)e);
            }
        }
    }

    private void flushLogTrackEvents() {
        LinkedList events = this.ltManager.getEvents();
        this.flushEvents(events, LOGTRACK_LISTNAME);
    }

    private void flushConfigTrackEvents() {
        LinkedList events = this.ctManager.getEvents();
        this.flushEvents(events, CONFIGTRACK_LISTNAME);
    }

    private void processDlist(String dListName) {
        boolean moreEventsToProcess = true;
        while (moreEventsToProcess) {
            moreEventsToProcess = this.processNextEventReport(dListName, this.maxEventBatchSize);
        }
        try {
            this.storage.flush();
        }
        catch (AgentStorageException exc) {
            this.log.error((Object)"Failed to flush agent storage", (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNextEventReport(String dListName, int batchSize) {
        boolean moreEventsToProcess = false;
        Iterator i = this.storage.getListIterator(dListName);
        if (i == null) {
            return false;
        }
        TrackEventReport report = new TrackEventReport();
        int numEventsProcessed = 0;
        while (numEventsProcessed <= batchSize && i.hasNext()) {
            TrackEvent event;
            try {
                event = TrackEvent.decode((String)((String)i.next()));
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to decode record -- deleting: " + e));
                continue;
            }
            finally {
                ++numEventsProcessed;
                moreEventsToProcess = i.hasNext();
                continue;
            }
            this.log.debug((Object)("Adding event to report=" + event));
            report.addEvent(event);
        }
        if (!this.sendReportToServer(dListName, report)) {
            moreEventsToProcess = false;
            numEventsProcessed = 0;
        }
        this.removeProcessedEventsFromStorage(dListName, numEventsProcessed);
        return moreEventsToProcess;
    }

    private boolean sendReportToServer(String dListName, TrackEventReport report) {
        boolean succeeded = true;
        if (report.getEvents().length > 0) {
            this.log.debug((Object)"Sending report to server");
            try {
                if (dListName.equals(LOGTRACK_LISTNAME)) {
                    this.client.trackSendLog(report);
                } else if (dListName.equals(CONFIGTRACK_LISTNAME)) {
                    this.client.trackSendConfigChange(report);
                } else {
                    throw new IllegalArgumentException("Unknown DList name");
                }
                this.log.debug((Object)"Completed sending report to server");
            }
            catch (AgentCallbackClientException e) {
                this.log.error((Object)("Error sending report to server: " + (Object)((Object)e)));
                succeeded = false;
            }
        }
        return succeeded;
    }

    private void removeProcessedEventsFromStorage(String dListName, int numEventsProcessed) {
        Iterator i = this.storage.getListIterator(dListName);
        while (numEventsProcessed > 0 && i != null && i.hasNext()) {
            i.next();
            i.remove();
            --numEventsProcessed;
        }
    }

    public void die() {
        this.flushLogTrackEvents();
        this.flushConfigTrackEvents();
        this.shouldDie = true;
        this.interruptMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.myThread = Thread.currentThread();
        while (!this.shouldDie) {
            this.flushLogTrackEvents();
            this.flushConfigTrackEvents();
            this.processDlist(LOGTRACK_LISTNAME);
            this.processDlist(CONFIGTRACK_LISTNAME);
            Object object = this.interrupter;
            synchronized (object) {
                try {
                    this.interrupter.wait(this.waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

