/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import org.hyperic.hq.plugin.system.HypervCollector;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.Win32MeasurementPlugin;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;

public class HyperVMeasurementPlugin
extends Win32MeasurementPlugin {
    protected static String getPath(Metric metric) {
        String obj = "\\" + metric.getObjectPropString() + "\\" + metric.getAttributeName();
        obj = obj.replaceAll("%3A", ":");
        return obj;
    }

    private MetricValue getAvailability(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        try {
            String[] instances = Pdh.getInstances((String)metric.getDomainName());
            String serviceName = metric.getObjectPropString();
            serviceName = serviceName.replaceAll("%3A", ":");
            this.getLog().debug((Object)("avail of: " + metric.getDomainName() + " service=" + serviceName));
            for (String instance : instances) {
                this.getLog().debug((Object)("avail: instance=" + instance));
                if (!serviceName.equals(instance)) continue;
                this.getLog().debug((Object)("avail is up for:" + metric.getDomainName() + ":" + serviceName));
                return new MetricValue(1.0);
            }
            return new MetricValue(0.0);
        }
        catch (Win32Exception e) {
            this.getLog().warn((Object)("avail is down for:" + metric.getDomainName() + e.getMessage()));
            return new MetricValue(0.0);
        }
    }

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        try {
            MetricValue metricValue = null;
            if (metric.isAvail()) {
                return this.getAvailability(metric);
            }
            String metricDomain = metric.getDomainName();
            this.getLog().debug((Object)("getValue: domain = " + metricDomain + " path=" + HyperVMeasurementPlugin.getPath(metric)));
            if ("collector".equals(metricDomain)) {
                return Collector.getValue((MeasurementPlugin)this, (Metric)metric);
            }
            if ("pdh".equals(metricDomain) || "pdh_formatted".equals(metricDomain)) {
                String obj = HyperVMeasurementPlugin.getPath(metric);
                this.getLog().debug((Object)("metric=" + obj + " domain=" + metricDomain));
                double val = "pdh".equals(metric.getDomainName()) ? new Pdh().getRawValue(obj) : new Pdh().getFormattedValue(obj);
                metricValue = new MetricValue(val);
            } else {
                metricValue = super.getValue(metric);
            }
            return metricValue;
        }
        catch (Win32Exception e) {
            this.getLog().warn((Object)("failed to get hyper-v metric:" + metric.getObjectPropString() + "\\" + metric.getAttributeName() + " " + e.getMessage()));
            return MetricValue.NONE;
        }
    }

    public Collector getNewCollector() {
        this.getLog().debug((Object)("[---------------]" + this.getTypeInfo().getName()));
        if (this.getPluginData().getPlugin("collector", this.getTypeInfo().getName()) == null) {
            this.getPluginData().addPlugin("collector", "Hyper-V Logical Processor", HypervCollector.class.getName());
        }
        return super.getNewCollector();
    }
}

