/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.SigarMeasurementPlugin;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.jdbc.DBUtil;

public class EngineMeasurementPlugin
extends SigarMeasurementPlugin {
    private static final HashMap connectionCache = new HashMap();
    private static final HashMap pidsCache = new HashMap();
    private static final String SIGAR_DOMAIN = "sybase.engine.sigar";

    public MetricValue getValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue res;
        this.getLog().debug((Object)("[getValue] metric=" + metric));
        if (metric.getDomainName().equals(SIGAR_DOMAIN)) {
            res = this.getSigarValue(metric);
        } else if (metric.getAttributeName().equals("Availability")) {
            res = this.getAvailability(metric);
        } else if (metric.getAttributeName().startsWith("EngineUtilization")) {
            res = Collector.getValue((MeasurementPlugin)this, (Metric)metric);
        } else {
            throw new MetricNotFoundException(metric.getAttributeName());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetricValue getAvailability(Metric metric) throws MetricNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        Properties props = metric.getProperties();
        String eId = metric.getObjectProperties().getProperty("id");
        double res = 0.0;
        Connection conn = null;
        String url = props.getProperty("jdbcUrl", "");
        String user = props.getProperty("jdbcUser", "");
        String pass = props.getProperty("jdbcPassword", "");
        try {
            conn = this.getCachedConnection(url, user, pass);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select status from sysengines where engine=" + eId);
            if (rs.next()) {
                String status = rs.getString("status").trim();
                this.getLog().debug((Object)("[getAvailability] egine '" + eId + "' status='" + status + "'"));
                res = status.equalsIgnoreCase("online") ? 1.0 : 0.5;
            } else {
                this.getLog().debug((Object)("[getAvailability] egine '" + eId + "' status not found"));
            }
            if (conn == null) return new MetricValue(res);
        }
        catch (SQLException e) {
            try {
                this.getLog().error((Object)("Error getting engine '" + eId + "' pid -> " + e.getMessage()));
                DBUtil.closeJDBCObjects((Object)this.getLog(), (Connection)conn, null, null);
                this.removeCachedConnection(url, user, pass);
                return new MetricValue(res);
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                DBUtil.closeJDBCObjects((Object)this.getLog(), null, (Statement)stmt, rs);
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)this.getLog(), null, (Statement)stmt, (ResultSet)rs);
        return new MetricValue(res);
    }

    public MetricValue getSigarValue(Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        MetricValue res = null;
        String eId = metric.getProperties().getProperty("id");
        String ePid = (String)pidsCache.get(eId);
        if (ePid == null) {
            ePid = this.getEnginePID(metric.getProperties());
            pidsCache.put(eId, ePid);
            this.getLog().debug((Object)("Engine '" + eId + "' pid='" + ePid + "'"));
        }
        if (ePid == null) {
            throw new MetricNotFoundException("engine '" + eId + "' pid not found");
        }
        metric.setObjectName(metric.getObjectName().replace("%process.query%", ePid));
        try {
            res = super.getValue(metric);
        }
        catch (PluginException ex) {
            pidsCache.remove(eId);
            throw ex;
        }
        catch (MetricNotFoundException ex) {
            pidsCache.remove(eId);
            throw ex;
        }
        catch (MetricUnreachableException ex) {
            pidsCache.remove(eId);
            throw ex;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEnginePID(Properties props) {
        Statement stmt = null;
        ResultSet rs = null;
        String pid = null;
        String eId = props.getProperty("id");
        try {
            String url = props.getProperty("jdbcUrl", "");
            String user = props.getProperty("jdbcUser", "");
            String pass = props.getProperty("jdbcPassword", "");
            Connection conn = this.getCachedConnection(url, user, pass);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select osprocid from sysengines where engine=" + eId);
            if (rs.next()) {
                pid = rs.getString("osprocid");
            }
            DBUtil.closeJDBCObjects((Object)this.getLog(), null, (Statement)stmt, (ResultSet)rs);
        }
        catch (SQLException e) {
            this.getLog().debug((Object)("Error getting engine '" + eId + "' pid"));
        }
        finally {
            DBUtil.closeJDBCObjects((Object)this.getLog(), null, stmt, rs);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getCachedConnection(String url, String user, String pass) throws SQLException {
        String cacheKey = url + user + pass;
        Connection conn = null;
        HashMap hashMap = connectionCache;
        synchronized (hashMap) {
            conn = (Connection)connectionCache.get(cacheKey);
            if (conn == null) {
                conn = this.getConnection(url, user, pass);
                connectionCache.put(cacheKey, conn);
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCachedConnection(String url, String user, String pass) {
        String cacheKey = url + user + pass;
        HashMap hashMap = connectionCache;
        synchronized (hashMap) {
            connectionCache.remove(cacheKey);
        }
    }

    protected Connection getConnection(String url, String user, String password) throws SQLException {
        String pass = password == null ? "" : password;
        pass = pass.matches("^\\s*$") ? "" : pass;
        Properties props = new Properties();
        props.put("CHARSET_CONVERTER_CLASS", "com.sybase.jdbc3.utils.TruncationConverter");
        props.put("user", user);
        props.put("password", pass);
        return DriverManager.getConnection(url, props);
    }

    public String translate(String template, ConfigResponse config) {
        String rate = "";
        if (template.contains(":sigar:") && template.contains("%process.query%")) {
            int ri = (template = template.replace(":sigar:", ":sybase.engine.sigar:")).indexOf("__RATE__");
            if (ri > 0) {
                rate = template.substring(ri);
                template = template.substring(0, ri);
            }
            template = template + ",id=" + config.getValue("id") + rate;
        } else if (template.contains(":EngineUtilization")) {
            template = template.replace(":EngineUtilization", ":EngineUtilization" + config.getValue("id"));
        }
        return super.translate(template, config);
    }
}

