/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.hyperic.hq.plugin.sybase.SybasePluginException;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class SybaseErrorLogPlugin
extends LogFileTailPlugin {
    private static final String SEVERITY = "Severity:";
    private static final String ERROR_EXPR = "Severity:";
    private static final Pattern SEVERITY_PATTERN;
    private static final Pattern ERROR_PATTERN;

    public TrackEvent processLine(FileInfo info, String line) {
        try {
            if (!ERROR_PATTERN.matcher(line).find()) {
                return null;
            }
            return this.newTrackEvent(this.getTimeMillis(line), this.getErrorLevel(line), info.getName(), this.getMessage(line));
        }
        catch (NumberFormatException e) {
        }
        catch (SybasePluginException sybasePluginException) {
            // empty catch block
        }
        return null;
    }

    private String getMessage(String line) throws NumberFormatException, SybasePluginException {
        return line.split("\\s+", 3)[2];
    }

    private int getErrorLevel(String line) throws NumberFormatException, SybasePluginException {
        if (!SEVERITY_PATTERN.matcher(line).find()) {
            throw new SybasePluginException();
        }
        String[] array = line.split("Severity:");
        String[] array2 = array[1].split("\\s+");
        String level = array2[0].substring(0, array2[0].length() - 1);
        return Integer.parseInt(level);
    }

    private long getTimeMillis(String line) throws NumberFormatException {
        Calendar rtn = Calendar.getInstance();
        rtn.clear();
        String[] array = line.split(":");
        String date_buf = array[3];
        array = line.split("\\s+");
        String time_buf = array[1];
        array = date_buf.split("\\/");
        String[] array2 = time_buf.split(":");
        rtn.set(this.getInt(array[0]), this.getInt(array[1]), this.getInt(array[2]), this.getInt(array2[0]), this.getInt(array2[1]));
        return rtn.getTimeInMillis();
    }

    public int getInt(String integer) throws NumberFormatException {
        return Integer.parseInt(integer);
    }

    static {
        ERROR_PATTERN = SEVERITY_PATTERN = Pattern.compile("Severity:");
    }
}

