/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.sybase;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.hyperic.hq.plugin.sybase.SybaseServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.util.file.FileUtil;

public class SybaseProductPlugin
extends ProductPlugin {
    private static String[] jars = new String[]{"jConnect-6_0/classes/jconn3.jar", "jConnect-7_0/classes/jconn4.jar"};
    private static String saRole;
    private static boolean originalAIID;
    private static String PROP_CLASSPATH;
    private static String PROP_INSTALLPATH;
    Log log = this.getLog();

    protected static boolean isOriginalAIID() {
        return originalAIID;
    }

    protected static String getSaRole() {
        return saRole;
    }

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        Properties props = manager.getProperties();
        originalAIID = "true".equals(props.getProperty("sysbase.aiid.orginal", "true").toLowerCase());
        saRole = props.getProperty("sysbase.sa_role", "sa_role");
    }

    public String[] getClassPath(ProductPluginManager manager) {
        String[] res = this._getClassPath(manager);
        this.log.debug((Object)("[getClassPath] res=" + Arrays.asList(res)));
        return res;
    }

    private String[] _getClassPath(ProductPluginManager manager) {
        Properties props = manager.getProperties();
        if (props.getProperty(PROP_CLASSPATH) != null) {
            return props.getProperty(PROP_CLASSPATH).split(",");
        }
        if (props.getProperty(PROP_INSTALLPATH) != null) {
            return this.findJDBCJar(props.getProperty(PROP_INSTALLPATH));
        }
        String[] res = null;
        try {
            Sigar sigar = new Sigar();
            long[] pids = ProcessFinder.find((Sigar)sigar, (String)SybaseServerDetector.PTQL_QUERY);
            for (int n = 0; n < pids.length && res == null; ++n) {
                String installPath = sigar.getProcArgs(pids[n])[0];
                installPath = FileUtil.getParentDir((String)installPath, (int)3);
                res = this.findJDBCJar(installPath);
            }
        }
        catch (SigarException ex) {
            ex.printStackTrace();
        }
        if (res == null) {
            res = new String[]{};
        }
        return res;
    }

    private String[] findJDBCJar(String installPath) {
        this.log.debug((Object)("[getClassPath] testing " + PROP_INSTALLPATH + "='" + installPath + "'"));
        String[] res = null;
        File ip = new File(installPath);
        if (ip.exists()) {
            for (int i = 0; i < jars.length && res == null; ++i) {
                File jar = new File(ip, jars[i]);
                if (!jar.exists() || !jar.canRead()) continue;
                res = new String[]{jar.getAbsolutePath()};
            }
        }
        return res;
    }

    static {
        originalAIID = true;
        PROP_CLASSPATH = "sybase.classpath";
        PROP_INSTALLPATH = "sybase.installpath";
    }
}

