/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.openldap;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.config.ConfigResponse;

public class OpenLDAPServerDetector
extends ServerDetector
implements AutoServerDetector {
    private static final String SERVER_NAME = "OpenLDAP";
    private static final String PROCESS_NAME = "slapd";
    private static final String PTQL_QUERY = "State.Name.re=slapd,State.Name.Pne=$1,Args.0.re=.*slapd$";
    private final Log log = this.getLog();

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList servers = new ArrayList();
        List paths = this.getServerProcessList();
        for (int i = 0; i < paths.size(); ++i) {
            String dir = (String)paths.get(i);
            List found = this.getServerList(dir);
            if (found.isEmpty()) continue;
            servers.addAll(found);
        }
        return servers;
    }

    private List getServerProcessList() {
        ArrayList<String> servers = new ArrayList<String>();
        long[] pids = OpenLDAPServerDetector.getPids((String)PTQL_QUERY);
        this.log.debug((Object)("[getServerProcessList] found '" + pids.length + "' pids"));
        for (int i = 0; i < pids.length; ++i) {
            String exe = OpenLDAPServerDetector.getProcExe((long)pids[i]);
            if (exe == null) {
                this.log.debug((Object)("[getServerProcessList] no info for pid '" + pids.length + "'"));
                continue;
            }
            File binary = new File(exe);
            if (!binary.isAbsolute()) {
                this.log.debug((Object)("[getServerProcessList] Process='" + binary + "' pid='" + pids.length + "' is not a valid process"));
                continue;
            }
            servers.add(binary.getAbsolutePath());
        }
        return servers;
    }

    public List getServerList(String path) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String installdir = OpenLDAPServerDetector.getParentDir((String)path, (int)2);
        String version = "";
        if (path.contains(PROCESS_NAME)) {
            File versionFile = new File(installdir + "/lib/libldap-2.3.so.0");
            boolean ok = versionFile.exists();
            if (ok) {
                version = "2.3.x";
            }
            this.log.debug((Object)("process=" + path + " version=" + version + " (" + versionFile + " " + (ok ? "found" : "NOT FOUND") + ")"));
            ServerResource server = this.createServerResource(installdir);
            ConfigResponse cprop = new ConfigResponse();
            cprop.setValue("version", version);
            server.setCustomProperties(cprop);
            this.setProductConfig(server, new ConfigResponse());
            server.setMeasurementConfig();
            server.setName(OpenLDAPServerDetector.getPlatformName() + " " + SERVER_NAME + " " + version);
            servers.add(server);
        } else {
            this.log.debug((Object)("process=" + path + " is not a OpenLdap)"));
        }
        return servers;
    }
}

