/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.cm.versioncontrol.jgit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAllCommand
extends AddCommand {
    private static Logger log = LoggerFactory.getLogger(AddAllCommand.class);
    private Collection<String> zfilepatterns = new LinkedList<String>();
    private WorkingTreeIterator zworkingTreeIterator;

    public AddAllCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.zfilepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.zworkingTreeIterator = f;
        return this;
    }

    public WorkingTreeIterator getWorkingTreeIterator() {
        return this.zworkingTreeIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirCache call() throws NoFilepatternException {
        if (this.zfilepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = false;
        if (this.zfilepatterns.contains(".")) {
            addAll = true;
        }
        ObjectInserter inserter = this.repo.newObjectInserter();
        try {
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            TreeWalk tw = new TreeWalk(this.repo);
            tw.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
            if (this.zworkingTreeIterator == null) {
                this.zworkingTreeIterator = new FileTreeIterator(this.repo);
            }
            tw.addTree((AbstractTreeIterator)this.zworkingTreeIterator);
            tw.setRecursive(true);
            if (!addAll) {
                tw.setFilter(PathFilterGroup.createFromStrings(this.zfilepatterns));
            }
            String lastAddedFile = null;
            while (tw.next()) {
                String path = tw.getPathString();
                if (log.isDebugEnabled()) {
                    log.debug("Iterating file: " + path);
                }
                WorkingTreeIterator f = (WorkingTreeIterator)tw.getTree(1, WorkingTreeIterator.class);
                if (tw.getTree(0, DirCacheIterator.class) == null && f != null && f.isEntryIgnored() || path.equals(lastAddedFile) || this.isUpdate() && tw.getTree(0, DirCacheIterator.class) == null) continue;
                DirCacheIterator c = (DirCacheIterator)tw.getTree(0, DirCacheIterator.class);
                if (f == null) continue;
                long sz = f.getEntryLength();
                DirCacheEntry entry = new DirCacheEntry(path);
                if (c == null || c.getDirCacheEntry() == null || !c.getDirCacheEntry().isAssumeValid()) {
                    entry.setLength(sz);
                    entry.setLastModified(f.getEntryLastModified());
                    entry.setFileMode(f.getEntryFileMode());
                    InputStream in = f.openEntryStream();
                    try {
                        entry.setObjectId((AnyObjectId)inserter.insert(3, sz, in));
                    }
                    finally {
                        in.close();
                    }
                    builder.add(entry);
                    lastAddedFile = path;
                    continue;
                }
                builder.add(c.getDirCacheEntry());
            }
            inserter.flush();
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, (Throwable)e);
        }
        finally {
            inserter.release();
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }
}

