/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.optimizer;

import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.ast.FunctionNode;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;

final class OptFunctionNode {
    FunctionNode fnode;
    private boolean[] numberVarFlags;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode functionNode) {
        this.fnode = functionNode;
        functionNode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptNode scriptNode, int n) {
        FunctionNode functionNode = scriptNode.getFunctionNode(n);
        return (OptFunctionNode)functionNode.getCompilerData();
    }

    static OptFunctionNode get(ScriptNode scriptNode) {
        return (OptFunctionNode)scriptNode.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int n) {
        if (n < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = n;
    }

    void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.fnode.getParamAndVarCount();
    }

    boolean isParameter(int n) {
        return n < this.fnode.getParamCount();
    }

    boolean isNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) >= 0 && this.numberVarFlags != null) {
            return this.numberVarFlags[n];
        }
        return false;
    }

    void setIsNumberVar(int n) {
        if ((n -= this.fnode.getParamCount()) < 0) {
            Kit.codeBug();
        }
        if (this.numberVarFlags == null) {
            int n2 = this.fnode.getParamAndVarCount() - this.fnode.getParamCount();
            this.numberVarFlags = new boolean[n2];
        }
        this.numberVarFlags[n] = true;
    }

    int getVarIndex(Node node) {
        int n = node.getIntProp(7, -1);
        if (n == -1) {
            Node node2;
            int n2 = node.getType();
            if (n2 == 55) {
                node2 = node;
            } else if (n2 == 56 || n2 == 156) {
                node2 = node.getFirstChild();
            } else {
                throw Kit.codeBug();
            }
            n = this.fnode.getIndexForNameNode(node2);
            if (n < 0) {
                throw Kit.codeBug();
            }
            node.putIntProp(7, n);
        }
        return n;
    }
}

