/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.tomcat;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.PluginException;

public class JBossUtil {
    private static final String PROP_NAMING_CONNECTOR = "connector.jndi.name";
    private static final String JNDI_FACTORY = "org.jboss.security.jndi.JndiLoginInitialContextFactory";
    private static final String PROP_JNP_TIMEOUT = "jnp.timeout";
    private static final String PROP_JNP_SOTIMEOUT = "jnp.sotimeout";
    private static final String DEFAULT_JNP_TIMEOUT = System.getProperty("jnp.timeout", String.valueOf(30000));
    private static final String DEFAULT_JNP_SOTIMEOUT = System.getProperty("jnp.sotimeout", DEFAULT_JNP_TIMEOUT);
    private static final String[][] NAMING_PROPS = new String[][]{{"connector.jndi.name", "jmx/rmi/RMIAdaptor"}, {"java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory"}, {"java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces"}, {"jnp.disableDiscovery", "true"}, {"jnp.timeout", DEFAULT_JNP_TIMEOUT}, {"jnp.sotimeout", DEFAULT_JNP_SOTIMEOUT}};
    private static final String[] STAT_PROVIDER = new String[]{"StatisticsProvider", "Stats"};
    private static final String[] STAT_PROVIDER_4 = new String[]{"statisticsProvider", "stats"};
    private static Log log = LogFactory.getLog((String)"JBossUtil");
    private static HashMap serverCache = new HashMap();
    private static HashMap jsr77LowerCase = new HashMap();
    private static HashMap lowerCaseURLMappings = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServerConnection getMBeanServerConnection(Properties config) throws NamingException, RemoteException {
        MBeanServerConnection adaptor;
        Properties props = new Properties();
        for (int i = 0; i < NAMING_PROPS.length; ++i) {
            props.setProperty(NAMING_PROPS[i][0], NAMING_PROPS[i][1]);
        }
        props.putAll((Map<?, ?>)config);
        props.put("java.naming.provider.url", config.get("jmx.url"));
        if (props.getProperty("java.naming.security.principal") != null) {
            props.setProperty("java.naming.factory.initial", JNDI_FACTORY);
        }
        InitialContext ctx = new InitialContext(props);
        try {
            Object o = ctx.lookup(props.getProperty(PROP_NAMING_CONNECTOR));
            log.debug((Object)("=> " + Arrays.asList(o.getClass().getInterfaces())));
            adaptor = (MBeanServerConnection)o;
        }
        finally {
            ctx.close();
        }
        return adaptor;
    }

    public static MBeanServerConnection getMBeanServerConnection(String url) throws NamingException, RemoteException {
        Properties config = new Properties();
        config.setProperty("java.naming.provider.url", url);
        return JBossUtil.getMBeanServerConnection(config);
    }

    private static String getServerURL(Metric metric) {
        return metric.getProperties().getProperty("java.naming.provider.url");
    }

    public static MBeanServerConnection getMBeanServerConnection(Metric metric) throws NamingException, RemoteException {
        return JBossUtil.getMBeanServerConnection(metric.getProperties());
    }

    private static MetricInvalidException invalid(Metric metric, Exception e) {
        String msg = "Malformed ObjectName [" + metric.getObjectName() + "]";
        return new MetricInvalidException(msg, (Throwable)e);
    }

    private static MetricUnreachableException unreachable(Metric metric, Exception e) {
        String msg = "Can't connect to MBeanServerConnection [" + metric.toDebugString() + "]: " + e;
        return new MetricUnreachableException(msg, (Throwable)e);
    }

    private static MetricNotFoundException notfound(Metric metric, Exception e) {
        String msg = "Metric not found [" + metric.toDebugString() + "]: " + e;
        return new MetricNotFoundException(msg, (Throwable)e);
    }

    private static PluginException error(Metric metric, Exception e) {
        String msg = "Invocation error [" + metric.toDebugString() + "]: " + e;
        return new PluginException(msg, (Throwable)e);
    }

    private static PluginException error(Metric metric, Exception e, String method) {
        String msg = "Method '" + method + "' invocation error [" + metric.toDebugString() + "]: " + e;
        return new PluginException(msg, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getRemoteMBeanValue(Metric metric) throws MetricNotFoundException, MetricInvalidException, MetricUnreachableException, PluginException {
        String lcAttr;
        Boolean jsr77Case;
        MBeanServerConnection mServer = null;
        boolean cached = true;
        String url = JBossUtil.getServerURL(metric);
        HashMap hashMap = serverCache;
        synchronized (hashMap) {
            mServer = (MBeanServerConnection)serverCache.get(url);
        }
        if (mServer == null) {
            cached = false;
            try {
                mServer = JBossUtil.getMBeanServerConnection(metric);
            }
            catch (NamingException e) {
                throw JBossUtil.unreachable(metric, e);
            }
            catch (RemoteException e) {
                throw JBossUtil.unreachable(metric, e);
            }
            HashMap e = serverCache;
            synchronized (e) {
                serverCache.put(url, mServer);
            }
        }
        String attrName = metric.getAttributeName();
        HashMap hashMap2 = lowerCaseURLMappings;
        synchronized (hashMap2) {
            jsr77Case = (Boolean)lowerCaseURLMappings.get(url);
        }
        boolean lc = jsr77Case != null ? jsr77Case : Character.isLowerCase(attrName.charAt(0));
        if (lc && (lcAttr = (String)jsr77LowerCase.get(attrName)) != null) {
            attrName = lcAttr;
        }
        try {
            ObjectName objName = new ObjectName(metric.getObjectName());
            if (attrName.substring(1).startsWith("tatistic")) {
                return JBossUtil.getJSR77Statistic(mServer, objName, metric, lc);
            }
            if (attrName.equals("__INSTANCE__")) {
                try {
                    mServer.getObjectInstance(objName);
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    return Boolean.FALSE;
                }
            }
            return mServer.getAttribute(objName, attrName);
        }
        catch (MalformedObjectNameException e) {
            throw JBossUtil.invalid(metric, e);
        }
        catch (InstanceNotFoundException e) {
            throw JBossUtil.notfound(metric, e);
        }
        catch (AttributeNotFoundException e) {
            if (attrName.equals("Availability")) {
                return new Double(1.0);
            }
            throw JBossUtil.notfound(metric, e);
        }
        catch (ReflectionException e) {
            throw JBossUtil.error(metric, e);
        }
        catch (MBeanException e) {
            throw JBossUtil.error(metric, e);
        }
        catch (RuntimeMBeanException e) {
            throw JBossUtil.error(metric, e);
        }
        catch (Exception e) {
            if (cached) {
                HashMap hashMap3 = serverCache;
                synchronized (hashMap3) {
                    serverCache.remove(url);
                }
                log.debug((Object)("MBeanServerConnection cache cleared for " + url));
                return JBossUtil.getRemoteMBeanValue(metric);
            }
            throw JBossUtil.unreachable(metric, e);
        }
    }

    static Double getJSR77Statistic(MBeanServerConnection mServer, ObjectName objName, Metric metric, boolean lc) throws MetricNotFoundException, MetricInvalidException, MetricUnreachableException, PluginException {
        long value;
        Stats stats;
        String[] attrs = lc ? STAT_PROVIDER_4 : STAT_PROVIDER;
        try {
            Boolean provider = (Boolean)mServer.getAttribute(objName, attrs[0]);
            if (provider == null || !provider.booleanValue()) {
                String msg = "MBeanServerConnection does not provide statistics";
                throw new PluginException(msg);
            }
            stats = (Stats)mServer.getAttribute(objName, attrs[1]);
        }
        catch (RemoteException e) {
            throw JBossUtil.unreachable(metric, e);
        }
        catch (InstanceNotFoundException e) {
            throw JBossUtil.notfound(metric, e);
        }
        catch (AttributeNotFoundException e) {
            throw JBossUtil.notfound(metric, e);
        }
        catch (ReflectionException e) {
            throw JBossUtil.error(metric, e);
        }
        catch (MBeanException e) {
            throw JBossUtil.error(metric, e);
        }
        catch (IOException e) {
            throw JBossUtil.error(metric, e);
        }
        if (stats == null) {
            throw new PluginException("MBeanServerConnection has no stats");
        }
        String statName = metric.getAttributeName().substring(9);
        Statistic stat = stats.getStatistic(statName);
        if (stat == null) {
            String msg = "Statistic '" + statName + "' not found [" + metric + "]";
            throw new MetricNotFoundException(msg);
        }
        if (stat instanceof CountStatistic) {
            value = ((CountStatistic)stat).getCount();
        } else if (stat instanceof RangeStatistic) {
            value = ((RangeStatistic)stat).getCurrent();
        } else {
            String msg = "Unsupported statistic type [" + statName.getClass().getName() + " for [" + metric + "]";
            throw new MetricInvalidException(msg);
        }
        return new Double(value);
    }
}

