/*
 * Decompiled with CFR 0.152.
 */
package com.hyperic.hq.rt.agent.commands;

import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.encoding.Base64;

public class RtPlugin_args
extends AgentRemoteValue {
    private static final String PARAM_CONFIG = "config";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_ID = "ID";
    private static final String PARAM_ENDUSER = "enduser";
    private static final String PARAM_COLLECTIPS = "collectIPs";

    public RtPlugin_args() {
    }

    public RtPlugin_args(AgentRemoteValue args) throws AgentRemoteException {
        ConfigResponse config;
        String configStr = args.getValue(PARAM_CONFIG);
        String type = args.getValue(PARAM_TYPE);
        String id = args.getValue(PARAM_ID);
        Boolean enduser = Boolean.valueOf(args.getValue(PARAM_ENDUSER));
        String collectIPsVal = args.getValue(PARAM_COLLECTIPS);
        Boolean collectIPs = collectIPsVal == null ? null : Boolean.valueOf(collectIPsVal);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        if (type == null) {
            throw new AgentRemoteException("Plugin type not given");
        }
        if (id == null) {
            throw new AgentRemoteException("Service ID not given");
        }
        this.setConfig(id, type, config, enduser, collectIPs);
    }

    public void setConfig(String id, String type, ConfigResponse config, Boolean enduser) throws AgentRemoteException {
        this.setConfig(id, type, config, enduser, null);
    }

    public void setConfig(String id, String type, ConfigResponse config, Boolean enduser, Boolean collectIPs) throws AgentRemoteException {
        String configStr;
        try {
            configStr = Base64.encode((byte[])config.encode());
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to encode plugin configuration: " + e.getMessage());
        }
        super.setValue(PARAM_CONFIG, configStr);
        super.setValue(PARAM_TYPE, type);
        super.setValue(PARAM_ID, id);
        super.setValue(PARAM_ENDUSER, enduser.toString());
        if (collectIPs != null) {
            super.setValue(PARAM_COLLECTIPS, collectIPs.toString());
        }
    }

    public ConfigResponse getConfigResponse() throws AgentRemoteException {
        ConfigResponse config;
        String configStr = this.getValue(PARAM_CONFIG);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        return config;
    }

    public Boolean getEndUser() {
        return Boolean.valueOf(this.getValue(PARAM_ENDUSER));
    }

    public Boolean getCollectIPs() {
        String val = this.getValue(PARAM_COLLECTIPS);
        if (val == null) {
            return null;
        }
        return Boolean.valueOf(val);
    }

    public String getType() {
        return this.getValue(PARAM_TYPE);
    }

    public Integer getID() {
        return new Integer(this.getValue(PARAM_ID));
    }

    public String getRtIdent() {
        return this.getID().toString() + this.getEndUser().toString();
    }
}

