/*
 * The instrumentation of the COVALENT-ANTIVIRUS-MIB module.
 */
#ifndef _COVALENT_ANTIVIRUS_MIB_H_
#define _COVALENT_ANTIVIRUS_MIB_H_

typedef struct {
    time_t lastTime;
    char lastDoc[ MAX_WWWDOCNAME ];
    char lastVirus[ MAX_WWWDOCNAME ];
    unsigned long count;
} av_mib_service_stats_t;

/* Results of the update activity */
#define UPDATE_SUCCESS	1
#define UPDATE_ERROR	2

typedef struct {
    int activity;
    time_t lastTime;
    time_t lastSuccessfullTime;
    unsigned long timeInterval; /* Should be in seconds */
    unsigned long updateCounter;
    unsigned long sinceLastSuccessfullCounter;
    char statusMsg[ MAX_SNMPADMINSTRING ];
} av_mib_update_activity_t;

void init_covalent_antivirus_mib(server_rec *s, pool *p);
void invoke_av_detected_log(request_rec *r);
void invoke_av_update_log(int result);

#ifdef AVDEBUG
#define PRINT_AVMIB(str) fprintf(stderr, "avmib-debug: %s\n", str);
#else
#define PRINT_AVMIB(str)
#endif

#endif /* _COVALENT_ANTIVIRUS_MIB_H_ */
