/*
 * Generic implementation components for the COVALENT-APACHE-STATUS-MIB.
 */
/* Apache includes */
#include <httpd.h>
#include <http_log.h>
#include <scoreboard.h>

/* SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <var_struct.h>

#include "covalent-snmp-config.h"
#include "apache-status-mib.h"


#ifdef COVALENT_APACHE_STATUS_MIB
#ifndef SNMP_MIN
#define SNMP_MIN(a,b)   (((a)<(b)) ? (a) : (b))
#endif

#define NEXT    FALSE
#define EXACT   TRUE
#define INDEX   2


int get_ctApacheProcessStatusIndex(struct variable *vp,
                oid *name, size_t *length, int exact,
                int first_index, unsigned int last_index)
{
oid *ptr;
process_score *process_info;
 
    ptr = &(vp->name[ vp->namelen++ ]);
    *ptr = first_index;
    while (*ptr <= last_index) {
        process_info = ap_get_scoreboard_process(first_index - 1);
        if (exact == NEXT) {
            if (0 > snmp_oid_compare(name, *length,
                              vp->name, vp->namelen)) {
                return(*ptr);
            }
        } else if (exact == EXACT) {
            if (0 == snmp_oid_compare(name, *length,
                              vp->name, vp->namelen)) {
                return(*ptr);
            }
        } else if (exact == INDEX) {
            if (0 >= snmp_oid_compare(name, SNMP_MIN(*length,vp->namelen),
                        vp->name, SNMP_MIN(*length, vp->namelen))) {
                return(*ptr);
            }
        }
        (*ptr)++;
    }
    return(-1);
}

int get_ctApacheThreadStatusIndex(struct variable *vp,
                oid *name, size_t *length, int exact,
                int process_index, unsigned int last_thread_index)
{
oid *ptr;

    ptr = &(vp->name[ vp->namelen++ ]);
    *ptr = 1;
    while (*ptr <= last_thread_index) {
        if (exact == NEXT) {
            if (0 > snmp_oid_compare(name, *length,
                                  vp->name, vp->namelen)) {
                return(*ptr);
            }
        } else if (exact == EXACT) {
            if (0 == snmp_oid_compare(name, *length,
                                  vp->name, vp->namelen)) {
                return(*ptr);
            }
        }
        (*ptr)++;
    }
    return(-1);
}
#endif /* COVALENT_APACHE_STATUS_MIB */

