/* General includes */
#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#ifndef WIN32
#include <sys/time.h>
#include <signal.h>
#include <fcntl.h>
#include <strings.h>
#include <limits.h>
#include <sys/socket.h>
#else
#include <time.h>
#endif

/* Apache includes */
#include <httpd.h>

/* SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_agent.h>
#include <snmp_vars.h>
#include <var_struct.h>
#include <agent_trap.h>
#include <read_config.h>
#include <agent_read_config.h>
#include <default_store.h>
#include <ds_agent.h>
#include <snmp_debug.h>
#include <callback.h>
#include <mibgroup/agentx/agentx_config.h>
#include <mibgroup/mibII/system_mib.h>
#include <mibgroup/mibII/snmp_mib.h>
#include <mibgroup/mibII/vacm_vars.h>
#include <mibgroup/mibII/sysORTable.h>
#include <mibgroup/snmpv3/usmUser.h>
#include <mibgroup/snmpv3/usmStats.h>
#include <mibgroup/snmpv3/snmpMPDStats.h>
#include <mibgroup/snmpv3/snmpEngine.h>
#include <mibgroup/date_n_time.h>

/* SDBM includes */
#include <covalent_sdbm.h>

void snmp_common_sdbm_required(void);
void snmp_common_sdbm_required(void) {
datum key = { NULL, 0};
covalent_sdbm_open(NULL, 0, 0);
covalent_sdbm_close(NULL);
covalent_sdbm_fetch(NULL, key);
covalent_sdbm_store(NULL, key, key, 0);
covalent_sdbm_firstkey(NULL);
covalent_sdbm_nextkey(NULL);
}


void snmp_common_required(void);
void snmp_common_required(void) {
/* All SNMP functions. */
send_easy_trap (0, 0);
snmp_shutdown("");
snmp_set_do_debugging(1);
snmp_read(NULL);
init_agent("");
init_system_mib();
init_sysORTable();
init_snmp_mib();
init_vacm_vars();
init_snmpEngine();
init_snmpMPDStats();
init_usmStats();
init_usmUser();
init_snmp("");
init_master_agent(0, NULL, NULL);
/* Util functions. */
date_n_time(0, 0);
/* AgentX functions */
init_agentx_config();
}
