#ifndef	__WWW_MIB_H__
#define	__WWW_MIB_H__

#ifndef MAX_WWWDOCNAME
#define MAX_WWWDOCNAME MAX_DISPLAYSTRING
#endif

#ifndef MAX_WWWDOCLASTNSTATUSMSG
#define MAX_WWWDOCLASTNSTATUSMSG MAX_DISPLAYSTRING
#endif

/* The www protocol definition which contains the protocol identifier
 * the request types and response types.
 */
typedef struct www_protocol {
    int number;
    const char *protocol;
    const int nr_of_request_types;
    const char **request_types;
    const int nr_of_response_types;
    const int *response_types;
    struct www_protocol *next;
} www_protocol_t;

www_protocol_t *get_www_protocol_definition_by_name(char *protocol);
www_protocol_t *get_www_protocol_definition_by_number(int protocol);
int get_request_type_index(www_protocol_t *protocol, const char *method);
const char*get_request_type(www_protocol_t *protocol, int index);
const int get_number_of_request_types(www_protocol_t *protocol);
int get_response_type_index(www_protocol_t *protocol, int response_type);
const int get_response_type(www_protocol_t *protocol, int index);
const int get_number_of_response_types(www_protocol_t *protocol);

/* The optional functions that are needed by other www protocol modules
 * to enable the SNMP monitoring for them.
 */
int covalent_snmp_www_protocol_register(www_protocol_t *protocol);
int covalent_snmp_www_protocol_init(void);

APR_DECLARE_OPTIONAL_FN(int, covalent_snmp_www_protocol_register,
                             (www_protocol_t *protocol));

#ifdef WWW_MIB
void init_www_mib(apr_pool_t *p, const char *persdir);
#else /* WWW_MIB */
#define init_www_mib(p, persdir)
#endif /* WWW_MIB */

#endif /* __WWW_MIB_PROTOCOL_H__ */
