/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectGeneric;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.OptionalStructureWrapper;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingReference
extends PassThroughComponent {
    private final IContainer m_container;
    private final PropertyDefinition m_property;
    private final boolean m_isNillable;
    private String m_type;
    private String m_referenceText;
    private String m_referenceQName;
    private final IContextObj m_contextObject;
    private final NameDefinition m_name;
    private final boolean m_isSynthetic;
    private IMapping m_mapping;
    private IComponent m_wrappedReference;

    public MappingReference(IContainer contain, PropertyDefinition prop, String type, String reftext, String refqname, IContextObj objc, NameDefinition name, boolean synth, boolean nillable) {
        this.m_container = contain;
        this.m_property = prop;
        this.m_type = type;
        this.m_referenceText = reftext;
        this.m_referenceQName = refqname;
        this.m_contextObject = objc;
        this.m_name = name;
        this.m_isSynthetic = synth;
        this.m_isNillable = nillable;
    }

    public IMapping getMapping() {
        return this.m_mapping;
    }

    public boolean isOptional() {
        return this.m_property.isOptional();
    }

    public String getType() {
        return this.m_type;
    }

    public void setLinkages() throws JiBXException {
        DefinitionContext defc = this.m_container.getDefinitionContext();
        IMapping mdef = null;
        if (this.m_referenceText != null && (mdef = defc.getClassMapping(this.m_referenceText)) == null) {
            mdef = defc.getClassMapping(this.m_referenceQName);
        }
        if (mdef == null) {
            mdef = defc.getClassMapping(this.m_type);
        }
        this.m_mapping = mdef;
        IComponent wrap = null;
        PropertyDefinition prop = this.m_property;
        if (mdef == null) {
            if (this.m_name != null) {
                throw new JiBXException("Name not allowed for generic mapping of type " + this.m_type);
            }
            wrap = new DirectGeneric(this.m_container, this.m_type, prop);
        } else if (this.m_isSynthetic && mdef.isAbstract() && !mdef.isBase()) {
            wrap = new DirectGeneric(this.m_container, this.m_type, prop);
        } else {
            if (prop.isImplicit()) {
                prop.setOptional(false);
            }
            if (mdef.getName() == null) {
                mdef.setLinkages();
                ArrayList nss = mdef.getNamespaces();
                if (nss != null) {
                    for (int i = 0; i < nss.size(); ++i) {
                        defc.addImpliedNamespace((NamespaceDefinition)nss.get(i));
                    }
                }
            }
            String type = mdef.getBoundType();
            if (prop.getTypeName() == null) {
                prop = new PropertyDefinition(type, this.m_contextObject, prop.isOptional());
            }
            if (this.m_name == null) {
                wrap = mdef.buildRef(this.m_container, this.m_contextObject, prop.getTypeName(), prop);
            } else {
                PropertyDefinition propcopy = new PropertyDefinition(prop);
                propcopy.setOptional(false);
                wrap = mdef.buildRef(this.m_container, this.m_contextObject, prop.getTypeName(), propcopy);
                this.m_wrappedReference = wrap;
                if (mdef.getName() == null) {
                    IComponent icomp = wrap;
                    wrap = new ElementWrapper(defc, this.m_name, icomp, this.m_isNillable);
                    if (prop.isImplicit()) {
                        ((ElementWrapper)wrap).setDirect(true);
                    }
                    if (prop.isOptional()) {
                        if (icomp instanceof ComponentProperty) {
                            ((ComponentProperty)icomp).setSkipping(true);
                        }
                        ((ElementWrapper)wrap).setOptionalNormal(true);
                        ((ElementWrapper)wrap).setStructureObject(true);
                        ((ElementWrapper)wrap).setDirect(true);
                        wrap = new OptionalStructureWrapper(wrap, prop, true);
                    }
                } else {
                    throw new JiBXException("Name not allowed for reference to mapping of type " + type + ", which already defines a name");
                }
            }
            this.m_type = mdef.getReferenceType();
        }
        this.setWrappedComponent(wrap);
        super.setLinkages();
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        super.genContentUnmarshal(mb);
        if (this.m_wrappedReference != null && this.m_property.isThis() && this.m_wrappedReference.hasAttribute() && this.m_wrappedReference.hasContent()) {
            mb.appendPOP();
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping reference to " + (this.m_referenceText == null ? this.m_type : this.m_referenceText));
        if (this.m_property != null) {
            System.out.print(" using " + this.m_property.toString());
        }
        System.out.println();
        if (this.m_component != null) {
            this.m_component.print(depth + 1);
        }
    }
}

