/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld;

import com.thoughtworks.xstream.XStream;
import com.vmware.sva.common.HistorySerialGenerationInfo;
import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.common.SerialGenerationInfo;
import com.vmware.sva.common.SvaUtilities;
import com.vmware.sva.common.VersionedSerializable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BldSerialization {
    private static XStream xstream = null;
    private static final String[] serializablePackagePrefixes;
    public static final String SERIAL_VERSION_HISTORY = "com/vmware/sva/bld/BldSerialization.versions";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BldObjectOutputStream oos = new BldObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytesToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }

    public static String objectToXml(Object obj) throws Exception {
        return xstream.toXML(obj);
    }

    public static Object xmlToObject(String xml) throws Exception {
        return xstream.fromXML(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        try {
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            String string = fileData.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String filePath, String str) throws IOException {
        FileWriter fw = new FileWriter(filePath);
        try {
            fw.write(str);
        }
        finally {
            fw.close();
        }
    }

    public static void writeObjectToXmlFile(String filePath, Object obj) throws Exception {
        BldSerialization.writeStringToFile(filePath, BldSerialization.objectToXml(obj));
    }

    public static Object readObjectFromXmlFile(String filePath) throws Exception {
        return BldSerialization.xmlToObject(BldSerialization.readFileAsString(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToByteFile(String filePath, Object obj) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(filePath);
        BldObjectOutputStream objOut = null;
        try {
            objOut = new BldObjectOutputStream(fileOut);
            objOut.writeObject(obj);
        }
        finally {
            if (objOut != null) {
                objOut.close();
            } else {
                fileOut.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFromByteFile(String filePath) throws IOException, ClassNotFoundException {
        FileInputStream fileIn = new FileInputStream(filePath);
        ObjectInputStream objIn = null;
        try {
            objIn = new ObjectInputStream(fileIn);
            Object object = objIn.readObject();
            return object;
        }
        finally {
            try {
                if (objIn != null) {
                    objIn.close();
                } else {
                    fileIn.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ZipFile(ZipOutputStream out, String basePath, String fname) throws IOException {
        byte[] buf = new byte[1024];
        String fpath = basePath + "/" + fname;
        File file = new File(fpath);
        if (file.isDirectory()) {
            String[] fnames = file.list();
            out.putNextEntry(new ZipEntry(fname + "/"));
            for (String f : fnames) {
                BldSerialization.ZipFile(out, basePath, fname + "/" + f);
            }
        } else {
            out.putNextEntry(new ZipEntry(fname));
            FileInputStream in = new FileInputStream(fpath);
            try {
                int len;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ZipFiles(String basePath, String fname) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ZipOutputStream out = new ZipOutputStream(baos);
            try {
                BldSerialization.ZipFile(out, basePath, fname);
            }
            finally {
                out.close();
            }
        }
        finally {
            baos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UnzipFiles(String basePath, byte[] data) throws IOException {
        byte[] buf = new byte[1024];
        ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(data));
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            String outFilename = basePath + "/" + entry.getName();
            if (entry.isDirectory()) {
                new File(outFilename).mkdirs();
            } else {
                FileOutputStream out = new FileOutputStream(outFilename);
                try {
                    int len;
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            entry = in.getNextEntry();
        }
        in.close();
    }

    public static boolean isClassBldSerializable(Class<?> cl) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            return false;
        }
        if (cl.getComponentType() != null || SvaUtilities.isEnumClass(cl)) {
            return true;
        }
        String classname = cl.getName();
        if (!classname.startsWith("com.vmware.sva.")) {
            return true;
        }
        boolean found = false;
        for (String prefix : serializablePackagePrefixes) {
            if (!classname.startsWith(prefix)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        VersionedSerializable versionedSerializable = cl.getAnnotation(VersionedSerializable.class);
        return versionedSerializable != null && versionedSerializable.value();
    }

    public static HistorySerialGenerationInfo getBldSerialGenerationInfo() throws IOException {
        InputStream in = GetResource.getResourceAsStream(SERIAL_VERSION_HISTORY);
        if (in == null) {
            throw new IOException("Class version history resource not found: com/vmware/sva/bld/BldSerialization.versions");
        }
        try {
            HistorySerialGenerationInfo historySerialGenerationInfo = new HistorySerialGenerationInfo((Reader)new InputStreamReader(in));
            return historySerialGenerationInfo;
        }
        catch (IOException e) {
            throw new IOException("Problem reading serial generation information from resource com/vmware/sva/bld/BldSerialization.versions: " + e.getMessage(), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    static {
        xstream = new XStream();
        try {
            SerialGeneration.setSerialGenerationInfo((SerialGenerationInfo)BldSerialization.getBldSerialGenerationInfo());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        serializablePackagePrefixes = new String[]{"com.vmware.sva.blc.", "com.vmware.sva.bld.", "com.vmware.sva.common.", "com.vmware.sva.database.", "com.vmware.sva.domainservice.", "com.vmware.sva.memberdomain.", "com.vmware.sva.platformservice.", "com.vmware.sva.sasdomain.", "com.vmware.sva.scdomain.", "com.vmware.sva.services.", "com.vmware.sva.svadomain.", "com.vmware.sva.tools.", "com.vmware.sva.util.", "com.vmware.sva.zkmgmtserver.", "com.vmware.sva.zkservice.", "com.vmware.sva.pseudosvadomain."};
    }

    public static class GetResource {
        public static InputStream getResourceAsStream(String name) {
            URL url = GetResource.class.getClassLoader().getResource(name);
            if (url != null) {
                try {
                    return url.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class BldObjectOutputStream
    extends ObjectOutputStream {
        BldObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            assert (BldSerialization.isClassBldSerializable(cl)) : "Class is not BLD serializable: " + cl.getName();
        }
    }
}

