/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.nonpersistent;

import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.AbstractBldInformation;
import com.vmware.sva.bld.AbstractBusinessLogicDomain;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.nonpersistent.NonPersistentBldDatabase;
import com.vmware.sva.bld.nonpersistent.NonPersistentMessageService;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractBldDatabase;
import com.vmware.sva.services.blcevents.controlevent.BlcStartEvent;
import com.vmware.sva.services.health.BldHealthWatcher;
import com.vmware.sva.services.health.HealthService;
import com.vmware.sva.services.health.LocalDomainOfflineEvent;
import com.vmware.sva.services.logger.LoggerService;
import com.vmware.sva.zkservice.ZkClient;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractNonPersistentBld
extends AbstractBusinessLogicDomain
implements Runnable,
BldHealthWatcher {
    private final LoggerService loggerService;
    private final NonPersistentMessageService messageService;
    private final HealthService healthService;
    private ZkClient zkClient = null;
    private final UUID svaId;
    protected final boolean primaryMember;
    private NonPersistentBldDatabase database;
    private static final long serialVersionUID = 1L;
    private long generation = 0L;
    protected UUID instantiationId;

    public AbstractNonPersistentBld(UUID svaId, UUID bldId, String name, boolean primaryMember, List<String> zkServerAddresses) throws Exception {
        super(bldId, name);
        this.svaId = svaId;
        this.primaryMember = primaryMember;
        this.database = new NonPersistentBldDatabase(bldId.toString());
        if (!this.database.validate()) {
            throw new Exception("Inconsistent database for domain " + this.getName());
        }
        if (primaryMember) {
            this.log(Level.INFO, "Starting " + name + " as primary member");
            this.zkClient = new ZkClient(svaId, this);
        } else {
            this.log(Level.INFO, "Starting " + name + " as secondary member");
            this.zkClient = new ZkClient(svaId, this, zkServerAddresses);
        }
        this.loggerService = new LoggerService(this);
        this.healthService = new HealthService(this, this.zkClient);
        this.messageService = new NonPersistentMessageService(this, this.zkClient);
    }

    @Override
    public BldType getType() {
        return BldType.Nonpersistent;
    }

    @Override
    public AbstractBldDatabase getDatabase() {
        return this.database;
    }

    public abstract AbstractBldInformation getBldInformation() throws Exception;

    @Override
    public void setDefaultBlc(AbstractBusinessLogicComponent blc) throws Exception {
        if (!this.blcMap.isEmpty()) {
            throw new Exception("BLD already started");
        }
        this.blcMap.put(blc.getId(), blc);
    }

    @Override
    public void commitTransaction(BldTransaction transaction) {
        this.transactionQueue.add(transaction);
    }

    @Override
    public boolean handleDomainOnline() {
        if (!this.blcMap.containsKey(SvaConstants.DefaultUUID)) {
            assert (false) : "Domain is online but has no default BLC";
            logger.log(Level.SEVERE, "Domain is online but has no default BLC");
        } else {
            try {
                this.startReplica(null);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to start domain replica: " + e.getMessage());
                return false;
            }
            ((AbstractBusinessLogicComponent)this.blcMap.get(SvaConstants.DefaultUUID)).queueEvent(new BlcStartEvent(SvaConstants.DefaultUUID));
        }
        return true;
    }

    @Override
    public void handleDomainOffline() {
        for (AbstractBusinessLogicComponent blc : this.blcMap.values()) {
            blc.queueEvent(new LocalDomainOfflineEvent());
        }
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    @Override
    protected boolean startDomain() {
        try {
            this.instantiationId = UUID.randomUUID();
            this.generation = this.database.getGeneration() + 1L;
            this.database.updateGeneration(this.generation);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to update domain generaton: " + e.getMessage());
            return false;
        }
        try {
            this.healthService.registerBldHealthWatcher(this);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to register with health service: " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    protected void closeDomain() {
        try {
            this.database.close();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to close database: " + e.getMessage());
        }
        try {
            this.zkClient.close();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to close zkClient: " + e.getMessage());
        }
    }

    @Override
    protected boolean stopDomain() {
        try {
            this.zkClient.forceOffline(false);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to set zookeeper client offline in noni-persistent domain: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void startReplica(UUID prevMasterId) throws Exception {
        this.zkClient.waitForOldSessionToExpire();
        super.startReplica(null);
        this.zkClient.createMessageQueue();
        this.messageService.startCheckingForMessages();
        this.zkClient.updateBldInformation(this.getBldInformation());
    }

    @Override
    protected void blcsStopped() {
        super.blcsStopped();
    }

    @Override
    protected void deleteDatabase() throws Exception {
        if (this.database != null) {
            this.database.delete();
            this.database = null;
        }
    }

    protected long getGeneration() {
        return this.generation;
    }

    public LoggerService getLoggerService() {
        return this.loggerService;
    }

    public UUID getSvaId() {
        return this.svaId;
    }

    @Override
    public UUID getBldInstantiationId(UUID bldId) {
        return this.zkClient.getBldInstantiationId(bldId);
    }

    public UUID getInstantiationId() {
        return this.instantiationId;
    }
}

