/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.nonpersistent;

import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.nonpersistent.NonPersistentBldDatabase;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcUndeliveredEvent;
import com.vmware.sva.services.blcevents.ResetBldSequenceNumberMessage;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import com.vmware.sva.zkservice.BldMessagesAvailableEvent;
import com.vmware.sva.zkservice.ZkClient;
import com.vmware.sva.zkservice.ZkOfflineException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.zookeeper.KeeperException;

public class NonPersistentMessageService
extends AbstractDomainService
implements BldEventWatcher {
    private static final long serialVersionUID = 1L;
    private final ZkClient zkClient;
    private final Map<UUID, Long> sequenceNumberMap = new HashMap<UUID, Long>();
    private final NonPersistentBldDatabase database;

    public NonPersistentMessageService(BusinessLogicDomainServiceAPI domain, ZkClient zkClient) throws Exception {
        super(SvaConstants.MESSAGE_SERVICE_ID, "Message Service", domain);
        this.zkClient = zkClient;
        this.database = (NonPersistentBldDatabase)domain.getDatabase();
    }

    public void startCheckingForMessages() throws Exception {
        this.flushMessages();
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) {
        String errorString = "NonPersisentMessageService.persistRequest should never be called";
        this.log(Level.SEVERE, errorString);
        assert (false) : errorString;
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        if (!(request instanceof BlcMessageRequest)) {
            this.log(Level.SEVERE, "MessageService received an object that was not a BlcMessageRequest: " + ((Object)((Object)request)).getClass());
            return;
        }
        AbstractBlcMessage msg = ((BlcMessageRequest)request).getMessage();
        if (msg.isDestinationLocal(this.localDomainId)) {
            UUID destinationBlc = msg.getHeader().getDestinationBlc();
            this.domain.queueLiveBlcEvent(destinationBlc, msg);
        } else {
            try {
                UUID destinationBld = msg.getHeader().getDestinationBld();
                if (!this.database.hasTransmitSeqNum(destinationBld)) {
                    this.log(Level.INFO, "Requesting domain " + destinationBld + " to reset sequence number");
                    ResetBldSequenceNumberMessage resetMsg = new ResetBldSequenceNumberMessage(this.domain.getId(), destinationBld);
                    this.zkClient.sendMessage(resetMsg);
                }
                long sequenceNumber = this.database.nextTransmitSeqNum(destinationBld);
                this.database.commit();
                msg.setSequenceNumber(sequenceNumber);
                this.zkClient.sendMessage(msg);
            }
            catch (Exception e) {
                this.log(Level.WARNING, "Unable to deliver inter-domain message from non-persistent domain: " + e.getMessage());
                UUID sourceBlc = msg.getHeader().getSourceBlc();
                BlcUndeliveredEvent undeliveredBlcMessage = new BlcUndeliveredEvent(sourceBlc, msg);
                this.queueBlcEventFromServiceEvent(sourceBlc, undeliveredBlcMessage);
            }
        }
    }

    @Override
    public void handleBldEvent(AbstractBldEvent bldEvent) {
        if (bldEvent instanceof BldMessagesAvailableEvent) {
            this.checkForMessages();
        } else {
            assert (false) : "Nonpersistent message service received unknown BLC event: " + bldEvent.getClass().toString();
            this.log(Level.SEVERE, "Nonpersistent message service received unknown BLC event: " + bldEvent.getClass().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMessages() {
        NonPersistentMessageService nonPersistentMessageService = this;
        synchronized (nonPersistentMessageService) {
            try {
                List<String> messageIds = this.zkClient.getMessageList(this);
                for (String messageId : messageIds) {
                    AbstractBlcMessage blcMessage = this.zkClient.getMessage(messageId);
                    long sequenceNumber = blcMessage.getSequenceNumber();
                    UUID sourceBld = blcMessage.getHeader().getSourceBld();
                    if (!this.isDuplicateMessage(sourceBld, sequenceNumber)) {
                        this.log(Level.INFO, "Received message seq " + sequenceNumber + " for BLC " + blcMessage.getHeader().getDestinationBlc() + " from " + sourceBld + "/" + blcMessage.getHeader().getSourceBlc());
                        this.queueBlcEventFromServiceEvent(blcMessage.getHeader().getDestinationBlc(), blcMessage);
                        this.sequenceNumberMap.put(sourceBld, sequenceNumber);
                    } else {
                        this.log(Level.INFO, "Discarding duplicate message " + sequenceNumber);
                    }
                    this.zkClient.deleteMessage(messageId);
                }
            }
            catch (KeeperException e) {
                this.log(Level.INFO, "Could not get inter-domain messages for non-persistent domain: assuming replica has gone offline", e);
            }
            catch (ZkOfflineException e) {
                this.log(Level.INFO, "Could not get inter-domain messages for non-persistent domain: assuming replica has gone offline", (Throwable)((Object)e));
            }
            catch (Exception e) {
                assert (false) : "Exception while receiving inter-domain messages for non-persistent domain: " + e.getMessage();
                this.log(Level.SEVERE, "Exception while receiving inter-domain messages for non-persistent domain: " + e.getMessage());
            }
        }
    }

    private boolean isDuplicateMessage(UUID sourceBld, long sequenceNumber) {
        if (this.sequenceNumberMap.containsKey(sourceBld)) {
            long lastSequenceNumber = this.sequenceNumberMap.get(sourceBld);
            if (sequenceNumber <= lastSequenceNumber) {
                return true;
            }
            if (sequenceNumber > lastSequenceNumber + 1L) {
                String errorMsg = "persistent message service lost message: received msg " + sequenceNumber + ", last msg was " + lastSequenceNumber;
                assert (false) : errorMsg;
                this.log(Level.SEVERE, errorMsg);
            }
        }
        return false;
    }

    private synchronized void flushMessages() {
        try {
            List<String> messageIds = this.zkClient.getMessageList(this);
            this.log(Level.INFO, "Flushing " + messageIds.size() + " message(s) when restarting domain");
            for (String messageId : messageIds) {
                try {
                    AbstractBlcMessage blcMessage = this.zkClient.getMessage(messageId);
                    this.log(Level.INFO, "Flushing message " + messageId + ": " + ((Object)((Object)blcMessage)).getClass().toString());
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Failed to get message while flushing queue", e);
                }
                this.zkClient.deleteMessage(messageId);
            }
        }
        catch (KeeperException e) {
            this.log(Level.WARNING, "Could not flush inter-domain messages for non-persistent domain: assuming replica has gone offline", e);
        }
        catch (ZkOfflineException e) {
            this.log(Level.INFO, "Could not flush inter-domain messages for non-persistent domain: assuming replica has gone offline", (Throwable)((Object)e));
        }
        catch (Exception e) {
            assert (false) : "Exception while flusing inter-domain messages for non-persistent domain: " + e.getMessage();
            this.log(Level.SEVERE, "Exception while flushing inter-domain messages for non-persistent domain", e);
        }
    }
}

