/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.health;

import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.AbstractBldInformation;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.domainservice.AbstractSyncService;
import com.vmware.sva.services.health.BldHealthWatcher;
import com.vmware.sva.services.health.CheckPseudoSvaOnlineRequest;
import com.vmware.sva.services.health.CheckPseudoSvaOnlineResponse;
import com.vmware.sva.services.health.CleanupDeadSvaRequest;
import com.vmware.sva.services.health.CleanupDeadSvaResponse;
import com.vmware.sva.services.health.PseudoSvaOnlineChangeEvent;
import com.vmware.sva.services.health.RemoteDomainOnlineChangeEvent;
import com.vmware.sva.services.health.RemoteDomainOnlineChangeRequest;
import com.vmware.sva.services.health.RemoteDomainOnlineChangeResponse;
import com.vmware.sva.services.health.UnregisterRemoteDomainOnlineNotification;
import com.vmware.sva.services.health.UpdateBldInformationRequest;
import com.vmware.sva.services.health.UpdateBldInformationResponse;
import com.vmware.sva.zkservice.BldDomainOnlineEvent;
import com.vmware.sva.zkservice.BldDomainsOnlineChangeEvent;
import com.vmware.sva.zkservice.BldPseudoSvaEvent;
import com.vmware.sva.zkservice.ZkClient;
import com.vmware.sva.zkservice.ZkOfflineException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.zookeeper.KeeperException;

public class HealthService
extends AbstractSyncService
implements BldEventWatcher {
    public static final UUID SERVICE_ID = UUID.fromString("558ddbe4-f9a7-417e-9902-70f261608200");
    private final ZkClient zkClient;
    private final Map<UUID, Set<UUID>> remoteDomainNotifyMap = new HashMap<UUID, Set<UUID>>();
    private Set<UUID> onlineDomains;
    private boolean online;
    BldHealthWatcher bldHealthWatcher;
    private static final long serialVersionUID = 1L;
    private boolean pseudoSvaOnline;
    private final Set<UUID> pseudoSvaWatchers = new HashSet<UUID>();

    public HealthService(BusinessLogicDomainServiceAPI domain, ZkClient zkClient) throws Exception {
        super(SERVICE_ID, "Health Service", domain);
        this.zkClient = zkClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        super.start();
        Object object = this.remoteDomainNotifyMap;
        synchronized (object) {
            this.onlineDomains = new HashSet<UUID>();
        }
        object = this;
        synchronized (object) {
            this.online = false;
            this.bldHealthWatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        HealthService healthService = this;
        synchronized (healthService) {
            if (this.bldHealthWatcher != null) {
                this.zkClient.unregisterDomainOnline(this);
                this.bldHealthWatcher = null;
                this.online = false;
            }
        }
        super.stop();
    }

    public synchronized void registerBldHealthWatcher(BldHealthWatcher bldHealthWatcher) throws BldException, KeeperException, InterruptedException {
        assert (this.bldHealthWatcher == null) : "registerBldHealthWather can only be called once";
        this.zkClient.registerDomainOnline(this);
        this.bldHealthWatcher = bldHealthWatcher;
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) {
        if (request instanceof RemoteDomainOnlineChangeRequest) {
            return this.handleRemoteDomainOnlineChangeRequest((RemoteDomainOnlineChangeRequest)request);
        }
        if (request instanceof UnregisterRemoteDomainOnlineNotification) {
            this.handleUnregisterRemoteDomainOnlineNotification((UnregisterRemoteDomainOnlineNotification)request);
            return null;
        }
        if (request instanceof CheckPseudoSvaOnlineRequest) {
            return this.handleCheckPseudoSvaOnlineRequest((CheckPseudoSvaOnlineRequest)request);
        }
        if (request instanceof UpdateBldInformationRequest) {
            return this.handleUpdateBldInformationRequest((UpdateBldInformationRequest)request);
        }
        if (request instanceof CleanupDeadSvaRequest) {
            return this.handleCleanupDeadSvaRequest((CleanupDeadSvaRequest)request);
        }
        assert (false) : "Unrecognized HealthRequest: " + ((Object)((Object)request)).getClass();
        this.log(Level.SEVERE, "Unrecognized HealthRequest: " + ((Object)((Object)request)).getClass());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteDomainOnlineChangeResponse handleRemoteDomainOnlineChangeRequest(RemoteDomainOnlineChangeRequest request) {
        UUID bldId = request.getBldId();
        AbstractBldInformation bldInformation = null;
        Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
        synchronized (map) {
            if (request.getWatch()) {
                if (this.remoteDomainNotifyMap.containsKey(request.getBldId())) {
                    Set<UUID> l = this.remoteDomainNotifyMap.get(request.getBldId());
                    if (!l.contains(request.getBlcId())) {
                        l.add(request.getBlcId());
                    }
                } else {
                    HashSet<UUID> l = new HashSet<UUID>();
                    l.add(request.getBlcId());
                    this.remoteDomainNotifyMap.put(request.getBldId(), l);
                }
            }
            if (this.onlineDomains.contains(bldId)) {
                bldInformation = this.zkClient.getBldInformation(bldId);
            }
        }
        return new RemoteDomainOnlineChangeResponse(request.getRequestId(), bldId, bldInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnregisterRemoteDomainOnlineNotification(UnregisterRemoteDomainOnlineNotification request) {
        Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
        synchronized (map) {
            if (this.remoteDomainNotifyMap.containsKey(request.getBldId())) {
                Set<UUID> l = this.remoteDomainNotifyMap.get(request.getBldId());
                l.remove(request.getBlcId());
                if (l.isEmpty()) {
                    this.remoteDomainNotifyMap.remove(request.getBldId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckPseudoSvaOnlineResponse handleCheckPseudoSvaOnlineRequest(CheckPseudoSvaOnlineRequest request) {
        Set<UUID> set = this.pseudoSvaWatchers;
        synchronized (set) {
            if (request.getWatch()) {
                this.pseudoSvaWatchers.add(request.getBlcId());
            }
            return new CheckPseudoSvaOnlineResponse(request.getRequestId(), this.pseudoSvaOnline);
        }
    }

    private UpdateBldInformationResponse handleUpdateBldInformationRequest(UpdateBldInformationRequest request) {
        AbstractBldInformation bldInformation = request.getBldInformation();
        UpdateBldInformationResponse response = null;
        UUID requestId = request.getRequestId();
        try {
            this.zkClient.updateBldInformation(bldInformation);
            response = new UpdateBldInformationResponse(requestId);
        }
        catch (ZkOfflineException e) {
            this.log(Level.WARNING, "Failed to update BLD information", (Throwable)((Object)e));
            response = new UpdateBldInformationResponse(requestId, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Failed to update BLD information", e);
            response = new UpdateBldInformationResponse(requestId, e);
        }
        return response;
    }

    private CleanupDeadSvaResponse handleCleanupDeadSvaRequest(CleanupDeadSvaRequest request) {
        UUID svaId = request.getSvaId();
        List<UUID> domainIds = request.getDomainIds();
        this.zkClient.cleanupDeadSva(svaId, domainIds);
        CleanupDeadSvaResponse response = new CleanupDeadSvaResponse(request.getBlcId());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlc(UUID blcId) {
        Object object = this.remoteDomainNotifyMap;
        synchronized (object) {
            LinkedList<UUID> keysToRemove = new LinkedList<UUID>();
            Set<UUID> keys = this.remoteDomainNotifyMap.keySet();
            for (UUID key : keys) {
                Set<UUID> l = this.remoteDomainNotifyMap.get(key);
                l.remove(blcId);
                if (!l.isEmpty()) continue;
                keysToRemove.add(key);
            }
            for (UUID key : keysToRemove) {
                this.remoteDomainNotifyMap.remove(key);
            }
        }
        object = this.pseudoSvaWatchers;
        synchronized (object) {
            this.pseudoSvaWatchers.remove(blcId);
        }
    }

    @Override
    public synchronized void handleBldEvent(AbstractBldEvent bldEvent) {
        if (bldEvent instanceof BldDomainOnlineEvent) {
            this.handleBldDomainOnlineEvent((BldDomainOnlineEvent)bldEvent);
        } else if (bldEvent instanceof BldDomainsOnlineChangeEvent) {
            this.handleBldDomainsOnlineChangeEvent((BldDomainsOnlineChangeEvent)bldEvent);
        } else if (bldEvent instanceof BldPseudoSvaEvent) {
            this.handleBldPseudoSvaEvent((BldPseudoSvaEvent)bldEvent);
        } else {
            assert (false) : "Health service received invalid event: " + bldEvent.getClass();
            this.log(Level.SEVERE, "Health service received invalid event: " + bldEvent.getClass());
        }
    }

    private void handleBldDomainOnlineEvent(BldDomainOnlineEvent bldEvent) {
        boolean newOnline = bldEvent.getOnline();
        if (!this.online && newOnline) {
            this.setDomainOnline();
        } else if (this.online && !newOnline) {
            this.setDomainOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBldDomainsOnlineChangeEvent(BldDomainsOnlineChangeEvent bldEvent) {
        if (this.online) {
            Set<UUID> newOnlineDomains;
            try {
                newOnlineDomains = this.zkClient.getOnlineDomains(true);
            }
            catch (Exception e) {
                this.log(Level.WARNING, "Could not get online domain list: " + e.getMessage());
                newOnlineDomains = new HashSet<UUID>();
            }
            this.sendRemoteOfflineDomainEvents(newOnlineDomains);
            Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
            synchronized (map) {
                this.onlineDomains = this.sendRemoteOnlineDomainEvents(newOnlineDomains);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBldPseudoSvaEvent(BldPseudoSvaEvent bldEvent) {
        try {
            this.pseudoSvaOnline = this.zkClient.isPseudoSvaOnline(true);
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Could not get pseudo-SVA online status: " + e.getMessage());
            this.pseudoSvaOnline = false;
        }
        PseudoSvaOnlineChangeEvent event = new PseudoSvaOnlineChangeEvent(this.pseudoSvaOnline);
        Set<UUID> set = this.pseudoSvaWatchers;
        synchronized (set) {
            for (UUID blcId : this.pseudoSvaWatchers) {
                this.queueBlcEventFromServiceEvent(blcId, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRemoteOfflineDomainEvents(Set<UUID> newOnlineDomains) {
        Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
        synchronized (map) {
            HashSet<UUID> offlineDomains = new HashSet<UUID>(this.onlineDomains);
            offlineDomains.removeAll(newOnlineDomains);
            offlineDomains.retainAll(this.remoteDomainNotifyMap.keySet());
            for (UUID bldId : offlineDomains) {
                for (UUID blcId : this.remoteDomainNotifyMap.get(bldId)) {
                    this.domain.queueLiveBlcEvent(blcId, new RemoteDomainOnlineChangeEvent(bldId, null));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<UUID> sendRemoteOnlineDomainEvents(Set<UUID> newOnlineDomains) {
        Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
        synchronized (map) {
            HashSet<UUID> watchedOnlineDomains = new HashSet<UUID>(newOnlineDomains);
            watchedOnlineDomains.removeAll(this.onlineDomains);
            watchedOnlineDomains.retainAll(this.remoteDomainNotifyMap.keySet());
            for (UUID bldId : watchedOnlineDomains) {
                AbstractBldInformation bldInformation = this.zkClient.getBldInformation(bldId);
                if (bldInformation == null) {
                    newOnlineDomains.remove(bldId);
                    continue;
                }
                for (UUID blcId : this.remoteDomainNotifyMap.get(bldId)) {
                    this.domain.queueLiveBlcEvent(blcId, new RemoteDomainOnlineChangeEvent(bldId, bldInformation));
                }
            }
        }
        return newOnlineDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDomainOnline() {
        this.online = true;
        try {
            this.pseudoSvaOnline = this.zkClient.isPseudoSvaOnline(true);
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Could not get pseudo-SVA online status: " + e.getMessage());
            this.online = false;
        }
        if (this.online) {
            if (this.bldHealthWatcher.handleDomainOnline()) {
                Map<UUID, Set<UUID>> map = this.remoteDomainNotifyMap;
                synchronized (map) {
                    this.onlineDomains = new HashSet<UUID>();
                    try {
                        Set<UUID> newOnlineDomains = this.zkClient.getOnlineDomains(true);
                        this.onlineDomains = this.sendRemoteOnlineDomainEvents(newOnlineDomains);
                    }
                    catch (Exception e) {
                        this.log(Level.WARNING, "Could not get online domain list: " + e.getMessage());
                        this.online = false;
                    }
                }
            }
            this.online = false;
        }
        if (!this.online) {
            this.log(Level.WARNING, "Failed to place domain online");
            this.zkClient.forceOffline(true);
        }
    }

    private void setDomainOffline() {
        this.online = false;
        this.bldHealthWatcher.handleDomainOffline();
    }
}

