/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.messages;

import com.vmware.sva.common.mgmtevents.FaultReporter;
import com.vmware.sva.common.mgmtevents.ProgressReporter;
import com.vmware.sva.common.mgmtevents.TaskReporter;
import com.vmware.sva.messaging.ws.ConverterUtil;
import com.vmware.sva.messaging.ws.model.mgmtevents.AbstractManagementEvent;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BaseMessage.class);
    private final AbstractManagementEvent event;
    private boolean isTask = false;
    private boolean isFault = false;
    private boolean isProgress = false;
    private String description;

    public BaseMessage(com.vmware.sva.common.mgmtevents.AbstractManagementEvent event) {
        this.event = (AbstractManagementEvent)ConverterUtil.convert(event, null);
        if (log.isInfoEnabled()) {
            log.info("Event from core: " + event.getClass().getSimpleName() + " with id " + event.getBlcId());
        }
        if (event instanceof TaskReporter) {
            this.isTask = true;
            if (log.isInfoEnabled()) {
                log.info("   task id: " + ((TaskReporter)((Object)event)).getTaskId());
            }
        }
        if (event instanceof FaultReporter) {
            this.isFault = true;
            if (log.isInfoEnabled()) {
                log.info("   fault: " + ((FaultReporter)((Object)event)).getException().getMessage());
            }
            this.description = ((FaultReporter)((Object)event)).getException().getMessage();
        } else {
            this.description = "No error message available";
        }
        if (event instanceof ProgressReporter) {
            this.isProgress = true;
            if (log.isInfoEnabled()) {
                log.info("   progress: " + ((ProgressReporter)((Object)event)).getProgress());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public AbstractManagementEvent getEvent() {
        return this.event;
    }

    public boolean isProgress() {
        return this.isProgress;
    }
}

