/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.webservice;

import com.vmware.sva.messaging.ws.model.IPv4Address;
import com.vmware.sva.messaging.ws.model.MemberSvaConfig;
import com.vmware.sva.messaging.ws.model.NetworkInterface;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.StorageCluster;
import com.vmware.sva.messaging.ws.model.StorageClusterConfig;
import com.vmware.sva.messaging.ws.model.StorageEntityNetworkReconfig;
import com.vmware.sva.messaging.ws.model.SvaServerInfo;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.sva.SvaserviceStub;
import com.vmware.sva.webservice.WebServiceInterfaceFactory;
import com.vmware.sva.webservice.interfaces.SvaWebServiceInterface;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;

public class SvaWebServiceInterfaceImpl
implements SvaWebServiceInterface {
    private SvaserviceStub svaclient = null;
    private final Integer SOCKET_TIMEOUT = new Integer(60000);

    @Override
    public void connect(String serviceUrl) throws AxisFault {
        if (this.svaclient == null) {
            this.svaclient = new SvaserviceStub(serviceUrl);
            WebServiceInterfaceFactory.updateStub(this.svaclient, this.SOCKET_TIMEOUT, "8443");
        }
    }

    public void connect(String serviceUrl, int timeOut) throws AxisFault {
        if (this.svaclient == null) {
            this.svaclient = new SvaserviceStub(serviceUrl);
            WebServiceInterfaceFactory.updateStub(this.svaclient, timeOut, "8443");
        }
    }

    @Override
    public TaskRef svaWSCreateStorageCluster(String taskId, StorageClusterConfig config) throws Exception {
        TaskRef taskRef = null;
        if (this.svaclient != null) {
            taskRef = this.svaclient.createStorageCluster(taskId, config);
        }
        return taskRef;
    }

    @Override
    public TaskRef svaWSRecreateStorageCluster(String taskId) throws Exception {
        TaskRef taskRef = null;
        if (this.svaclient != null) {
            taskRef = this.svaclient.reCreateStorageCluster(taskId);
        }
        return taskRef;
    }

    @Override
    public SvaServerInfo svaWSGetSvaServerInfo() throws Exception {
        SvaServerInfo serverInfo = null;
        if (this.svaclient != null) {
            serverInfo = this.svaclient.getSvaServerInfo();
        }
        return serverInfo;
    }

    @Override
    public StorageCluster validateSvaForRecreate() throws Exception {
        StorageCluster storageCluster = null;
        if (this.svaclient != null) {
            storageCluster = this.svaclient.validateSvaForRecreate();
        }
        return storageCluster;
    }

    @Override
    public String getSvaVersion() throws Exception {
        if (this.svaclient != null) {
            return this.svaclient.getSvaVersion();
        }
        return null;
    }

    @Override
    public PingResult wsPing() throws Exception {
        PingResult pingResult = null;
        if (this.svaclient != null) {
            pingResult = this.svaclient.ping();
        }
        return pingResult;
    }

    @Override
    public void login(String username, String passwd) throws Exception {
        this.svaclient.login(username, passwd);
    }

    @Override
    public void close() throws Exception {
        if (this.svaclient != null) {
            this.svaclient._getServiceClient().cleanup();
        }
    }

    @Override
    public void exitMaintenanceMode() throws Exception {
        if (this.svaclient != null) {
            this.svaclient.exitMaintenanceMode();
        }
    }

    @Override
    public void shutdownSvaServer(boolean maintenanceMode) throws Exception {
        if (this.svaclient != null) {
            this.svaclient.shutdownSvaServer(maintenanceMode);
        }
    }

    @Override
    public InputStream getDiagnosticInfo(boolean includeDump) throws Exception {
        if (this.svaclient != null) {
            DataHandler diagnosticInfo = this.svaclient.getDiagnosticInfo(includeDump);
            return diagnosticInfo.getInputStream();
        }
        return null;
    }

    @Override
    public TaskRef reconfigureNetwork(NetworkInterface mgmtInterface, List<MemberSvaConfig> members, List<StorageEntityNetworkReconfig> storageEntities, IPv4Address psuedoSvaAddress) throws Exception {
        if (this.svaclient != null) {
            MemberSvaConfig[] ma = members.toArray(new MemberSvaConfig[0]);
            StorageEntityNetworkReconfig[] sea = storageEntities.toArray(new StorageEntityNetworkReconfig[0]);
            return this.svaclient.reconfigureNetwork(mgmtInterface, ma, sea, psuedoSvaAddress);
        }
        return null;
    }

    @Override
    public void reset(boolean force) throws Exception {
        if (this.svaclient != null) {
            this.svaclient.reset(force);
        }
    }

    @Override
    public String faultInsertion(List<String> args) throws Exception {
        if (this.svaclient != null) {
            String[] cArgs = args.toArray(new String[0]);
            return this.svaclient.faultInsertion(cArgs);
        }
        return null;
    }

    @Override
    public String listConstants() throws Exception {
        if (this.svaclient != null) {
            return this.svaclient.listConstants();
        }
        return null;
    }

    @Override
    public String listDebug() throws Exception {
        if (this.svaclient != null) {
            return this.svaclient.listDebug();
        }
        return null;
    }
}

