/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MessageSender;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelSender
implements MessageSender {
    private static Log log = LogFactory.getLog(ChannelSender.class);
    private Channel channel;
    private boolean synchronizeAllMembers;
    private MembershipManager membershipManager;

    public ChannelSender(Channel channel, MembershipManager membershipManager, boolean synchronizeAllMembers) {
        this.channel = channel;
        this.membershipManager = membershipManager;
        this.synchronizeAllMembers = synchronizeAllMembers;
    }

    public void sendToGroup(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        Member[] members = this.membershipManager.getMembers();
        if (members.length > 0) {
            try {
                if (this.synchronizeAllMembers) {
                    this.channel.send(members, (Serializable)this.toByteMessage(msg), 2566);
                } else {
                    this.channel.send(members, (Serializable)this.toByteMessage(msg), 2568);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Sent " + msg + " to group");
                }
            }
            catch (NotSerializableException e) {
                String message = "Could not send command message " + msg + " to group since it is not serializable.";
                log.error(message, e);
                throw new ClusteringFault(message, e);
            }
            catch (ChannelException e) {
                ChannelException.FaultyMember[] faultyMembers;
                log.error("Could not send message to some members", e);
                for (ChannelException.FaultyMember faultyMember : faultyMembers = e.getFaultyMembers()) {
                    Member member = faultyMember.getMember();
                    log.error("Member " + TribesUtil.getName(member) + " is faulty", faultyMember.getCause());
                }
            }
            catch (Exception e) {
                String message = "Error sending command message : " + msg + ". Reason " + e.getMessage();
                log.warn(message, e);
            }
        }
    }

    private ByteMessage toByteMessage(ClusteringCommand msg) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(msg);
        out.flush();
        out.close();
        return new ByteMessage(bos.toByteArray());
    }

    public void sendToSelf(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.send(new Member[]{this.channel.getLocalMember(true)}, (Serializable)this.toByteMessage(msg), 2);
            if (log.isDebugEnabled()) {
                log.debug("Sent " + msg + " to self");
            }
        }
        catch (Exception e) {
            throw new ClusteringFault(e);
        }
    }

    public void sendToMember(ClusteringCommand cmd, Member member) throws ClusteringFault {
        try {
            if (member.isReady()) {
                this.channel.send(new Member[]{member}, (Serializable)this.toByteMessage(cmd), 2566);
                if (log.isDebugEnabled()) {
                    log.debug("Sent " + cmd + " to " + TribesUtil.getName(member));
                }
            }
        }
        catch (NotSerializableException e) {
            String message = "Could not send command message to " + TribesUtil.getName(member) + " since it is not serializable.";
            log.error(message, e);
            throw new ClusteringFault(message, e);
        }
        catch (ChannelException e) {
            log.error("Could not send message to " + TribesUtil.getName(member));
            ChannelException.FaultyMember[] faultyMembers = e.getFaultyMembers();
            log.error("Member " + TribesUtil.getName(member) + " is faulty", faultyMembers[0].getCause());
        }
        catch (Exception e) {
            String message = "Could not send message to " + TribesUtil.getName(member) + ". Reason " + e.getMessage();
            log.warn(message, e);
        }
    }
}

