/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.HashMapUpdateLockable;
import org.apache.axis2.context.PropertyDifference;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext {
    private static final Log log = LogFactory.getLog(AbstractContext.class);
    private static final int DEFAULT_MAP_SIZE = 64;
    private static boolean DEBUG_ENABLED = log.isTraceEnabled();
    private static boolean DEBUG_PROPERTY_SET = false;
    public static final String COPY_PROPERTIES = "CopyProperties";
    protected long lastTouchedTime;
    protected transient AbstractContext parent;
    protected transient Map<String, Object> properties;
    private transient Map<String, Object> propertyDifferences;

    protected AbstractContext(AbstractContext parent) {
        this.parent = parent;
    }

    protected AbstractContext() {
    }

    public AbstractContext getParent() {
        return this.parent;
    }

    public boolean isAncestor(AbstractContext context) {
        if (context == null) {
            return false;
        }
        for (AbstractContext ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor != context) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getProperties() {
        this.initPropertiesMap();
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getPropertyNames() {
        this.initPropertiesMap();
        HashSet<String> copyKeySet = null;
        try {
            ((HashMapUpdateLockable)this.properties).lockForUpdate();
            copyKeySet = new HashSet<String>(this.properties.keySet());
        }
        finally {
            ((HashMapUpdateLockable)this.properties).unlockForUpdate();
        }
        return copyKeySet != null ? copyKeySet.iterator() : null;
    }

    public Object getProperty(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : this.properties.get(key);
        if (obj != null) {
            this.addPropertyDifference(key, obj, false);
        } else if (this.parent != null) {
            obj = this.parent.getProperty(key);
        }
        return obj;
    }

    public Object getLocalProperty(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : this.properties.get(key);
        if (obj != null || this.parent == null) {
            this.addPropertyDifference(key, obj, false);
        }
        return obj;
    }

    public Object getPropertyNonReplicable(String key) {
        Object obj;
        Object object = obj = this.properties == null ? null : this.properties.get(key);
        if (obj == null && this.parent != null) {
            obj = this.parent.getPropertyNonReplicable(key);
        }
        return obj;
    }

    public void setProperty(String key, Object value) {
        this.initPropertiesMap();
        this.properties.put(key, value);
        this.addPropertyDifference(key, value, false);
        if (DEBUG_ENABLED) {
            this.debugPropertySet(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyDifference(String key, Object value, boolean isRemoved) {
        if (!this.needPropertyDifferences()) {
            return;
        }
        AbstractContext abstractContext = this;
        synchronized (abstractContext) {
            if (this.propertyDifferences == null) {
                this.propertyDifferences = new HashMap<String, Object>(64);
            }
            this.propertyDifferences.put(key, new PropertyDifference(key, value, isRemoved));
        }
    }

    private boolean needPropertyDifferences() {
        ConfigurationContext cc = this.getRootContext();
        if (cc == null) {
            return false;
        }
        ClusterManager clusterManager = cc.getAxisConfiguration().getClusterManager();
        return clusterManager != null && clusterManager.getContextManager() != null;
    }

    public void setNonReplicableProperty(String key, Object value) {
        this.initPropertiesMap();
        this.properties.put(key, value);
    }

    public synchronized void removeProperty(String key) {
        if (this.properties == null) {
            return;
        }
        Object value = this.properties.get(key);
        if (value != null) {
            if (this.properties != null) {
                this.properties.remove(key);
            }
            this.addPropertyDifference(key, value, true);
        }
    }

    public synchronized void removePropertyNonReplicable(String key) {
        if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    public synchronized Map<String, Object> getPropertyDifferences() {
        if (this.propertyDifferences == null) {
            this.propertyDifferences = new HashMap<String, Object>(64);
        }
        return this.propertyDifferences;
    }

    public synchronized void clearPropertyDifferences() {
        if (this.propertyDifferences != null) {
            this.propertyDifferences.clear();
        }
    }

    public void setParent(AbstractContext context) {
        this.parent = context;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            Boolean copyProperties = (Boolean)properties.get(COPY_PROPERTIES);
            if (copyProperties != null && copyProperties.booleanValue()) {
                this.mergeProperties(properties);
            } else {
                if (this.properties != properties && DEBUG_ENABLED) {
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        this.debugPropertySet(entry.getKey(), entry.getValue());
                    }
                }
                this.properties = new HashMapUpdateLockable<String, Object>(properties);
            }
        }
    }

    public void mergeProperties(Map<String, Object> props) {
        if (props != null) {
            this.initPropertiesMap();
            for (String key : props.keySet()) {
                Object value = props.get(key);
                this.properties.put(key, value);
                if (!DEBUG_ENABLED) continue;
                this.debugPropertySet(key, value);
            }
        }
    }

    protected void touch() {
        this.lastTouchedTime = System.currentTimeMillis();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public void setLastTouchedTime(long t) {
        this.lastTouchedTime = t;
    }

    public void flush() throws AxisFault {
        Replicator.replicate(this);
    }

    public abstract ConfigurationContext getRootContext();

    private void debugPropertySet(String key, Object value) {
        if (DEBUG_PROPERTY_SET) {
            ClassLoader cl;
            String className = value == null ? "null" : value.getClass().getName();
            String classloader = "null";
            if (value != null && (cl = Utils.getObjectClassLoader(value)) != null) {
                classloader = cl.toString();
            }
            String valueText = value instanceof String ? value.toString() : null;
            String identity = this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this));
            log.debug("==================");
            log.debug(" Property set on object " + identity);
            log.debug("  Key =" + key);
            if (valueText != null) {
                log.debug("  Value =" + valueText);
            }
            log.debug("  Value Class = " + className);
            log.debug("  Value Classloader = " + classloader);
            log.debug("Call Stack = " + JavaUtils.callStackToString());
            log.debug("==================");
        }
    }

    private void initPropertiesMap() {
        if (this.properties == null) {
            this.properties = new HashMapUpdateLockable<String, Object>(64);
        }
    }
}

