/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.axiom.attachments.utils.IOUtils;

public class DeploymentClassLoader
extends URLClassLoader {
    private URL[] urls = null;
    private List embedded_jars;

    public DeploymentClassLoader(URL[] urls, List embedded_jars, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
        this.embedded_jars = embedded_jars;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] raw = null;
            try {
                String completeFileName = name;
                completeFileName = completeFileName.replace('.', '/').concat(".class");
                raw = this.getBytes(completeFileName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (raw == null) {
                throw new ClassNotFoundException("Class Not found : " + name);
            }
            clazz = this.defineClass(name, raw, 0, raw.length);
        }
        return clazz;
    }

    public URL findResource(String resource) {
        URL url = super.findResource(resource);
        if (url == null) {
            for (int i = 0; this.embedded_jars != null && i < this.embedded_jars.size(); ++i) {
                String libjar_name = (String)this.embedded_jars.get(i);
                try {
                    ZipEntry entry;
                    InputStream in = this.getJarAsStream(libjar_name);
                    ZipInputStream zin = new ZipInputStream(in);
                    while ((entry = zin.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (entryName == null || !entryName.endsWith(resource)) continue;
                        byte[] raw = IOUtils.getStreamAsByteArray(zin);
                        return new URL("jar", "", -1, this.urls[0] + "!/" + libjar_name + "!/" + entryName, new ByteUrlStreamHandler(raw));
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return url;
    }

    public Enumeration findResources(String resource) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        Enumeration<URL> e = super.findResources(resource);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        for (int i = 0; this.embedded_jars != null && i < this.embedded_jars.size(); ++i) {
            String libjar_name = (String)this.embedded_jars.get(i);
            try {
                ZipEntry entry;
                InputStream in = this.getJarAsStream(libjar_name);
                ZipInputStream zin = new ZipInputStream(in);
                while ((entry = zin.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (entryName == null || !entryName.endsWith(resource)) continue;
                    byte[] raw = IOUtils.getStreamAsByteArray(zin);
                    resources.add(new URL("jar", "", -1, this.urls[0] + "!/" + libjar_name + "!/" + entryName, new ByteUrlStreamHandler(raw)));
                }
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return Collections.enumeration(resources);
    }

    private byte[] getBytes(String resource) throws Exception {
        for (int i = 0; this.embedded_jars != null && i < this.embedded_jars.size(); ++i) {
            String libjar_name = (String)this.embedded_jars.get(i);
            InputStream in = this.getJarAsStream(libjar_name);
            byte[] bytes = this.getBytes(in, resource);
            if (bytes == null) continue;
            return bytes;
        }
        return null;
    }

    private byte[] getBytes(InputStream in, String resource) throws Exception {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(in);
        while ((entry = zin.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (entryName == null || !entryName.endsWith(resource)) continue;
            byte[] raw = IOUtils.getStreamAsByteArray(zin);
            zin.close();
            return raw;
        }
        return null;
    }

    private InputStream getJarAsStream(String libjar_name) throws Exception {
        return new ByteArrayInputStream(this.getBytes(this.urls[0].openStream(), libjar_name));
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getResource(name);
        }
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static class ByteURLConnection
    extends URLConnection {
        protected byte[] bytes;

        public ByteURLConnection(URL url, byte[] bytes) {
            super(url);
            this.bytes = bytes;
        }

        public void connect() {
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class ByteUrlStreamHandler
    extends URLStreamHandler {
        private byte[] bytes;

        public ByteUrlStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new ByteURLConnection(u, this.bytes);
        }
    }
}

