/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.async.AsyncUtils;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PollingFuture
extends Callback {
    private static final Log log = LogFactory.getLog(PollingFuture.class);
    private AsyncResponse response;
    private InvocationContext invocationCtx;

    public PollingFuture(InvocationContext ic) {
        this.response = ic.getAsyncResponseListener();
        this.invocationCtx = ic;
    }

    public void onComplete(AsyncResult result) {
        MessageContext responseMsgCtx;
        block4: {
            boolean debug = log.isDebugEnabled();
            if (debug) {
                log.debug("JAX-WS async response listener received the response");
            }
            responseMsgCtx = null;
            try {
                responseMsgCtx = AsyncUtils.createJAXWSMessageContext(result);
                responseMsgCtx.setInvocationContext(this.invocationCtx);
                responseMsgCtx.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException e) {
                this.response.onError(e, null);
                if (!debug) break block4;
                log.debug("An error occured while processing the async response.  " + e.getMessage());
            }
        }
        if (this.response == null) {
            // empty if block
        }
        this.response.onComplete(responseMsgCtx);
    }

    public void onError(Exception e) {
        if (e.getClass().isAssignableFrom(AxisFault.class)) {
            AxisFault fault = (AxisFault)e;
            MessageContext faultMessageContext = null;
            try {
                faultMessageContext = AsyncUtils.createJAXWSMessageContext(fault.getFaultMessageContext());
                faultMessageContext.setInvocationContext(this.invocationCtx);
                faultMessageContext.setMEPContext(this.invocationCtx.getRequestMessageContext().getMEPContext());
            }
            catch (WebServiceException wse) {
                this.response.onError(wse, null);
            }
            this.response.onError(e, faultMessageContext);
        } else {
            this.response.onError(e, null);
        }
    }
}

