/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.utils;

import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.addressing.util.ReferenceParameterList;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextUtils {
    private static final Log log = LogFactory.getLog(ContextUtils.class);

    public static void addProperties(SOAPMessageContext soapMessageContext, org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        HttpServletResponse res;
        ServletContext servletContext;
        ServiceDescription sd;
        soapMessageContext.putAll(jaxwsMessageContext.getProperties());
        EndpointDescription description = jaxwsMessageContext.getEndpointDescription();
        if (description != null && (sd = description.getServiceDescription()) != null) {
            String wsdlLocation = ((ServiceDescriptionWSDL)((Object)sd)).getWSDLLocation();
            if (wsdlLocation != null && !"".equals(wsdlLocation)) {
                URI wsdlLocationURI = JavaUtils.createURI(wsdlLocation);
                if (wsdlLocationURI == null) {
                    log.warn(Messages.getMessage("addPropertiesErr", wsdlLocation.toString(), description.getServiceQName().toString()));
                }
                ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.description", wsdlLocationURI, true);
            }
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.service", description.getServiceQName(), true);
        }
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        SOAPHeader header = null;
        if (msgContext != null && msgContext.getEnvelope() != null) {
            header = msgContext.getEnvelope().getHeader();
        }
        ReferenceParameterList list = new ReferenceParameterList(header);
        ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.reference.parameters", list);
        if (log.isDebugEnabled()) {
            log.debug("Added reference parameter list.");
        }
        if ((servletContext = (ServletContext)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT)) != null) {
            log.debug("Servlet Context Set");
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.servlet.context", servletContext);
        } else {
            log.debug("Servlet Context not found");
        }
        HttpServletRequest req = (HttpServletRequest)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            if (log.isDebugEnabled()) {
                log.debug("HTTPServletRequest not found");
            }
        } else {
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.servlet.request", req);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_REQUEST Set");
            }
            String pathInfo = null;
            try {
                pathInfo = req.getPathInfo();
            }
            catch (Throwable t) {
                log.debug("exception in getPathInfo", t);
            }
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.http.request.pathinfo", pathInfo);
            if (log.isDebugEnabled()) {
                if (pathInfo != null) {
                    log.debug("HTTP_REQUEST_PATHINFO Set");
                } else {
                    log.debug("HTTP_REQUEST_PATHINFO not found");
                }
            }
            String queryString = req.getQueryString();
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.http.request.querystring", queryString);
            if (log.isDebugEnabled()) {
                if (queryString != null) {
                    log.debug("HTTP_REQUEST_QUERYSTRING Set");
                } else {
                    log.debug("HTTP_REQUEST_QUERYSTRING not found");
                }
            }
            String method = req.getMethod();
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.http.request.method", method);
            if (log.isDebugEnabled()) {
                if (method != null) {
                    log.debug("HTTP_REQUEST_METHOD Set");
                } else {
                    log.debug("HTTP_REQUEST_METHOD not found");
                }
            }
        }
        if ((res = (HttpServletResponse)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Servlet Response not found");
            }
        } else {
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.servlet.response", res);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_RESPONSE Set");
            }
        }
    }

    public static void addWSDLProperties(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        ContextUtils.addWSDLProperties(jaxwsMessageContext, ContextUtils.getSOAPMessageContext(jaxwsMessageContext));
    }

    public static void addWSDLProperties(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext, SOAPMessageContext soapMessageContext) {
        OperationDescription op = jaxwsMessageContext.getOperationDescription();
        if (op != null && soapMessageContext != null) {
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.operation", op.getName(), true);
            EndpointInterfaceDescription eid = op.getEndpointInterfaceDescription();
            if (eid != null) {
                EndpointDescription ed = eid.getEndpointDescription();
                QName portType = eid.getPortType();
                if ((portType == null || portType.getLocalPart().length() == 0) && log.isDebugEnabled()) {
                    log.debug("Did not get port type from EndpointInterfaceDescription, attempting to get PortType from EndpointDescription");
                }
                if (ed != null) {
                    ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.port", ed.getPortQName(), true);
                }
                ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.interface", portType, true);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to read WSDL operation, port and interface properties");
        }
    }

    public static void addWSDLProperties_provider(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        ContextUtils.addWSDLProperties_provider(jaxwsMessageContext, ContextUtils.getSOAPMessageContext(jaxwsMessageContext));
    }

    public static void addWSDLProperties_provider(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext, SOAPMessageContext soapMessageContext) {
        QName op = jaxwsMessageContext.getOperationName();
        if (op != null && soapMessageContext != null) {
            ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.operation", op, true);
            EndpointDescription ed = jaxwsMessageContext.getEndpointDescription();
            if (ed != null) {
                ContextUtils.setProperty(soapMessageContext, "javax.xml.ws.wsdl.port", ed.getPortQName(), true);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to read WSDL operation, port and interface properties");
        }
    }

    private static SOAPMessageContext getSOAPMessageContext(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        WebServiceContext wsc;
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        ServiceContext serviceContext = msgContext.getServiceContext();
        SOAPMessageContext soapMessageContext = null;
        if (serviceContext != null && (wsc = (WebServiceContext)serviceContext.getProperty("javax.xml.ws.WebServiceContext")) != null) {
            soapMessageContext = (SOAPMessageContext)wsc.getMessageContext();
        }
        return soapMessageContext;
    }

    private static void setProperty(SOAPMessageContext context, String name, Object value) {
        ContextUtils.setProperty(context, name, value, false);
    }

    private static void setProperty(SOAPMessageContext context, String name, Object value, boolean logMessage) {
        context.put(name, value);
        context.setScope(name, MessageContext.Scope.APPLICATION);
        if (logMessage && log.isDebugEnabled()) {
            log.debug(name + " :" + value);
        }
    }
}

