/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.ExceptionFactory;

public class DescriptionKey {
    private QName serviceName = null;
    private URL wsdlUrl = null;
    private Class serviceClass = null;
    private ConfigurationContext configContext = null;

    public DescriptionKey(QName serviceName, URL wsdlUrl, Class serviceClass, ConfigurationContext configContext) {
        this.serviceName = serviceName;
        this.wsdlUrl = wsdlUrl;
        this.serviceClass = serviceClass;
        this.configContext = configContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DescriptionKey)) {
            return false;
        }
        DescriptionKey description = (DescriptionKey)o;
        if (this.serviceName == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("DescriptionRegistryErr0"));
        }
        return description.serviceName.equals(this.serviceName) && description.wsdlUrl != null ? description.wsdlUrl.equals(this.wsdlUrl) : this.wsdlUrl == null && description.serviceClass == this.serviceClass && description.configContext == this.configContext;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        hash += this.wsdlUrl == null ? 0 : this.wsdlUrl.hashCode();
        hash += this.serviceClass == null ? 0 : this.serviceClass.hashCode();
        return hash += this.configContext == null ? 0 : this.configContext.hashCode();
    }

    public ConfigurationContext getConfigContext() {
        return this.configContext;
    }

    public void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String printKey() {
        String sName = this.serviceName != null ? this.serviceName.toString() : "";
        String sWsdlURL = this.wsdlUrl != null ? this.wsdlUrl.toString() : "";
        String sClass = this.serviceClass != null ? this.serviceClass.toString() : "";
        String sConfig = this.configContext != null ? this.configContext.toString() : "";
        String key = sName + sWsdlURL + sClass + sConfig;
        return key;
    }
}

