/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAAJUtil {
    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env) {
        SOAPFactory factory;
        String nsURI;
        env.build();
        if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            factory = DOOMAbstractFactory.getSOAP11Factory();
        } else {
            nsURI = "http://www.w3.org/2003/05/soap-envelope";
            factory = DOOMAbstractFactory.getSOAP11Factory();
        }
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
        SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
        envelope.build();
        Element envElem = (Element)((Object)envelope);
        return envElem.getOwnerDocument();
    }

    public static SOAPEnvelopeImpl toDOOMSOAPEnvelope(SOAPEnvelope env) {
        SOAPFactory factory;
        String nsURI;
        env.build();
        if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            factory = DOOMAbstractFactory.getSOAP11Factory();
        } else {
            nsURI = "http://www.w3.org/2003/05/soap-envelope";
            factory = DOOMAbstractFactory.getSOAP11Factory();
        }
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
        SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
        envelope.build();
        return (SOAPEnvelopeImpl)envelope;
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOOMDocument(Document doc) {
        OMElement docElem = (OMElement)((Object)doc.getDocumentElement());
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(docElem.getXMLStreamReader(), null);
        return stAXSOAPModelBuilder.getSOAPEnvelope();
    }

    public static SOAPEnvelope toOMSOAPEnvelope(Element elem) {
        OMElement docElem = (OMElement)((Object)elem);
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(docElem.getXMLStreamReader(), null);
        return stAXSOAPModelBuilder.getSOAPEnvelope();
    }

    public static Element toDOM(OMElement element) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        element.serialize(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(bais).getDocumentElement();
    }
}

