/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.AxisRequestEntity;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPSender
extends AbstractHTTPSender {
    private static final Log log = LogFactory.getLog(HTTPSender.class);

    public void send(MessageContext msgContext, URL url, String soapActionString) throws IOException {
        String httpMethod = (String)msgContext.getProperty("HTTP_METHOD");
        if (httpMethod != null) {
            if ("GET".equalsIgnoreCase(httpMethod)) {
                this.sendViaGet(msgContext, url, soapActionString);
                return;
            }
            if ("DELETE".equalsIgnoreCase(httpMethod)) {
                this.sendViaDelete(msgContext, url, soapActionString);
                return;
            }
            if ("PUT".equalsIgnoreCase(httpMethod)) {
                this.sendViaPut(msgContext, url, soapActionString);
                return;
            }
        }
        this.sendViaPost(msgContext, url, soapActionString);
    }

    private void sendViaGet(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, getMethod, httpClient, soapActiionString);
        String soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActiionString);
        if (soapAction != null) {
            getMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, getMethod);
            this.handleResponse(msgContext, getMethod);
        }
        catch (IOException e) {
            log.info("Unable to sendViaGet to url[" + url + "]", e);
            throw AxisFault.makeFault(e);
        }
        finally {
            this.cleanup(msgContext, getMethod);
        }
    }

    private void cleanup(MessageContext msgContext, HttpMethod method) {
        if (msgContext.isPropertyTrue("AutoReleaseConnection") && (!(msgContext.getAxisOperation() instanceof OutInAxisOperation) || msgContext.getOptions().isUseSeparateListener())) {
            log.trace("AutoReleasing " + method);
            method.releaseConnection();
        }
    }

    private void sendViaDelete(MessageContext msgContext, URL url, String soapActiionString) throws AxisFault {
        DeleteMethod deleteMethod = new DeleteMethod();
        HttpClient httpClient = this.getHttpClient(msgContext);
        this.populateCommonProperties(msgContext, url, deleteMethod, httpClient, soapActiionString);
        try {
            this.executeMethod(httpClient, msgContext, url, deleteMethod);
            this.handleResponse(msgContext, deleteMethod);
        }
        catch (IOException e) {
            log.info("Unable to sendViaDelete to url[" + url + "]", e);
            throw AxisFault.makeFault(e);
        }
        finally {
            this.cleanup(msgContext, deleteMethod);
        }
    }

    private void sendViaPost(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        PostMethod postMethod = new PostMethod();
        if (log.isTraceEnabled()) {
            log.trace(Thread.currentThread() + " PostMethod " + postMethod + " / " + httpClient);
        }
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, postMethod, httpClient, soapActionString);
        postMethod.setRequestEntity(new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null) {
            postMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, postMethod);
            this.handleResponse(msgContext, postMethod);
        }
        catch (IOException e) {
            log.info("Unable to sendViaPost to url[" + url + "]", e);
            throw AxisFault.makeFault(e);
        }
        finally {
            if (msgContext.getOptions().isUseSeparateListener()) {
                msgContext.setProperty("AutoReleaseConnection", true);
            }
            this.cleanup(msgContext, postMethod);
        }
    }

    private void sendViaPut(MessageContext msgContext, URL url, String soapActionString) throws AxisFault {
        String soapAction;
        HttpClient httpClient = this.getHttpClient(msgContext);
        PutMethod putMethod = new PutMethod();
        MessageFormatter messageFormatter = this.populateCommonProperties(msgContext, url, putMethod, httpClient, soapActionString);
        putMethod.setRequestEntity(new AxisRequestEntity(messageFormatter, msgContext, this.format, soapActionString, this.chunked, this.isAllowedRetry));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            putMethod.setContentChunked(true);
        }
        if ((soapAction = messageFormatter.formatSOAPAction(msgContext, this.format, soapActionString)) != null) {
            putMethod.setRequestHeader("SOAPAction", soapAction);
        }
        try {
            this.executeMethod(httpClient, msgContext, url, putMethod);
            this.handleResponse(msgContext, putMethod);
        }
        catch (IOException e) {
            log.info("Unable to sendViaPut to url[" + url + "]", e);
            throw AxisFault.makeFault(e);
        }
        finally {
            this.cleanup(msgContext, putMethod);
        }
    }

    private void handleResponse(MessageContext msgContext, HttpMethodBase method) throws IOException {
        int statusCode = method.getStatusCode();
        log.trace("Handling response - " + statusCode);
        if (statusCode == 200) {
            this.processResponse(method, msgContext);
        } else if (statusCode != 202) {
            if (statusCode == 500 || statusCode == 400) {
                Object isTransportNonBlocking;
                MessageContext inMessageContext;
                OperationContext opContext;
                Header contenttypeHeader = method.getResponseHeader("Content-Type");
                String value = null;
                if (contenttypeHeader != null) {
                    value = contenttypeHeader.getValue();
                }
                if ((opContext = msgContext.getOperationContext()) != null && (inMessageContext = opContext.getMessageContext("In")) != null) {
                    inMessageContext.setProcessingFault(true);
                }
                if (value != null) {
                    this.processResponse(method, msgContext);
                }
                if ((isTransportNonBlocking = msgContext.getProperty("transportNonBlocking")) != null && ((Boolean)isTransportNonBlocking).booleanValue()) {
                    throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), method.getStatusText()));
                }
            } else {
                throw new AxisFault(Messages.getMessage("transportError", String.valueOf(statusCode), method.getStatusText()));
            }
        }
    }
}

