/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaUtilities;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SvaDebug {
    public static final String DEBUG_PROPERTIES = SvaDebug.getenv("DEBUG_PROPERTIES", null);
    public static final String DEBUG_PROPERTIES_PATH = SvaConstants.SvaConfigPath + "/debug.properties";
    public static final boolean IS_KERNEL_MONOLITHIC = SvaDebug.getprop("monolithic.kernel", true);
    public static volatile int DPE_FAULT_ADD_NTH_EVENT_LISTENER = SvaDebug.getprop("dpe.fault.add.nth.event.listener", -1);
    public static volatile int DPE_FAULT_REMOVE_NTH_EVENT_LISTENER = SvaDebug.getprop("dpe.fault.remove.nth.event.listener", -1);
    public static final String DPE_IGNORE_LIST = SvaDebug.getprop("dpe.ignore.list", "");
    public static final boolean MEMBER_DISK_FAULT_CHANGE_VOLUME_OWNER = SvaDebug.getprop("member.disk.fault.change_volume_owner", false);
    public static volatile String MEMBER_INDUCE_REMOTE_FAILURE_SCRIPT = SvaDebug.getprop("member.induce_remote_failure_script", null);
    public static final boolean LOG_SYSTEM_COMMANDS = SvaDebug.getprop("log.system.commands", false);
    public static final boolean LOG_SYSTEM_COMMANDS_STDERR = SvaDebug.getprop("log.system.commands.stderr", false);
    public static final boolean LOG_SYSTEM_COMMANDS_STDIN = SvaDebug.getprop("log.system.commands.stdin", false);
    public static final boolean LOG_SYSTEM_COMMANDS_STDOUT = SvaDebug.getprop("log.system.commands.stdout", false);
    public static final int PLATFORM_UNMAP_LOGICAL_UNIT_RETRIES = SvaDebug.getprop("platform.unmap.logical.unit.retries", 5);
    public static final int PLATFORM_ISCSI_FIND_ON_TRY_NR = SvaDebug.getprop("platform.iscsi.find_on_try_nr", 0);
    public static final boolean PLATFORM_ISCSI_RESCAN_IF_NOT_FOUND = SvaDebug.getprop("platform.iscsi.rescan_if_not_found", true);
    public static final int PLATFORM_ADD_NETWORK_CONFIG_RETRY_COUNT = SvaDebug.getprop("platform.network_config.retry_count", 5);
    public static final int PLATFORM_ADD_NETWORK_CONFIG_RETRY_DELAY = SvaDebug.getprop("platform.network_config.retry_delay_ms", 1000);
    public static final boolean PLATFORM_RAID_LOG_MDADM_DETAILS = SvaDebug.getprop("platform.raid.log_mdadm_details", false);
    public static final int PLATFORM_SYNC_FILES_TIMEOUT = SvaDebug.getprop("platform.sync_files_timeout_sec", 4);
    public static final boolean PLATFORM_ENABLE_RESYNC_THROTTLE = SvaDebug.getprop("platform.enable_resync_throttle", true);
    public static final String PLATFORM_EXTRA_DATA_PATH_FILTER_OPTIONS = SvaDebug.getprop("platform.extra.data_path_filter.options", null);
    public static final String PLATFORM_EXTRA_DEVICE_MAPPER_OPTIONS = SvaDebug.getprop("platform.extra.device_mapper.options", null);
    public static final String PLATFORM_EXTRA_FILESYSTEM_OPTIONS = SvaDebug.getprop("platform.extra.filesystem.options", null);
    public static final String PLATFORM_EXTRA_ISCSI_INITIATOR_OPTIONS = SvaDebug.getprop("platform.extra.iscsi_initiator.options", null);
    public static final String PLATFORM_EXTRA_ISCSI_TARGET_OPTIONS = SvaDebug.getprop("platform.extra.iscsi_target.options", null);
    public static final String PLATFORM_EXTRA_LOGICAL_VOLUME_OPTIONS = SvaDebug.getprop("platform.extra.logical_volume.options", null);
    public static final String PLATFORM_EXTRA_MOUNT_OPTIONS = SvaDebug.getprop("platform.extra.mount.options", null);
    public static final String PLATFORM_EXTRA_NETWORK_OPTIONS = SvaDebug.getprop("platform.extra.network.options", null);
    public static final String PLATFORM_EXTRA_NFS_EXPORT_OPTIONS = SvaDebug.getprop("platform.extra.nfs_export.options", null);
    public static final String PLATFORM_EXTRA_PHYSICAL_VOLUME_OPTIONS = SvaDebug.getprop("platform.extra.physical_volume.options", null);
    public static final String PLATFORM_EXTRA_RAID_CREATE_OPTIONS = SvaDebug.getprop("platform.extra.raid_create.options", null);
    public static final String PLATFORM_EXTRA_RAID_ASSEMBLE_OPTIONS = SvaDebug.getprop("platform.extra.raid_assemble.options", null);
    public static final String PLATFORM_EXTRA_VOLUME_GROUP_OPTIONS = SvaDebug.getprop("platform.extra.volume_group.options", null);
    public static final boolean MEMBER_REBOOT_TO_TERMINATE = SvaDebug.getprop("member.reboot_to_terminate", true);
    public static final boolean TERMINATE_INSTEAD_OF_REBOOT = SvaDebug.getprop("sva.terminate_instead_of_reboot", false);
    public static final boolean ALWAYS_PASS_AUTHENTICATE = SvaDebug.getprop("platform.always_pass_authenticate", false);
    public static final boolean CREATE_SINGLE_STORAGE_ENTITY = SvaDebug.getprop("sas.create_single_storage_entity", false);
    public static final long SINGLE_STORAGE_ENTITY_INDEX = SvaDebug.getprop("sas.single_storage_entity_index", 0).intValue();
    public static final boolean TRACE_MGMT_EVENTS = SvaDebug.getprop("sas.trace_mgmt_events", false);
    public static volatile boolean SAS_FAULT_INPUT_PARAM_VALIDATION = SvaDebug.getprop("sas.fault.input_param_validation", false);
    public static final boolean MGMT_DEBUGGING_COMMANDS_ENABLED = SvaDebug.getprop("mgmt.debugging_commands_enabled", false);
    public static final boolean LOG_EDGE_DURATION = SvaDebug.getprop("log_edge_duration", false);
    public static final boolean LOG_ZK_TRANSACTION_LOG_TRUNCATION = SvaDebug.getprop("zk.logZkTransactionLogTrunction", false);
    public static final long CLUSTER_SERVICE_LOG_HEARTBEAT = SvaDebug.getprop("cluster.service.log.heartbeat", -1).intValue();
    public static final boolean SC_VOLUME_DISK_DONT_CLOBBER_FAULTED = SvaDebug.getprop("sc.volumeDiskDontClobberFaulted", false);
    public static final boolean FORCE_UPGRADE = SvaDebug.getprop("upgrade.force", false);
    public static final boolean LOG_FT_MESSAGES = SvaDebug.getprop("log_ft_messages", true);
    public static final boolean DISABLE_CYCLIC_REBOOT_CHECK = SvaDebug.getprop("sva.cyclicRebootCheck.disable", false);
    public static final boolean DEBUG_NFS_STARTUP = SvaDebug.getprop("debug.nfs.startup", false);
    private static final Logger LOGGER = Logger.getLogger(SvaDebug.class.getName());
    private static Map<String, String> debugProps;
    private static Properties properties;

    private static String getenv(String envname, String defaultValue) {
        Map<String, String> env = System.getenv();
        return env.containsKey(envname) ? env.get(envname) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProperties() {
        if (properties == null) {
            properties = new Properties();
            String error = "Failure when reading Debug properties: ";
            FileReader in = null;
            try {
                in = new FileReader(DEBUG_PROPERTIES_PATH);
                properties.load(in);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            try {
                if (DEBUG_PROPERTIES != null) {
                    properties.load(new StringReader(DEBUG_PROPERTIES));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, error + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties() {
        FileWriter out = null;
        try {
            out = new FileWriter(DEBUG_PROPERTIES_PATH);
            properties.store(out, null);
            out.close();
            out = null;
        }
        catch (IOException e) {
            System.err.println("Failed to update Debug properties: " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static synchronized String getprop(String name, String defaultValue, boolean save) {
        SvaDebug.loadProperties();
        if (!properties.containsKey(name) && defaultValue != null) {
            properties.setProperty(name, defaultValue);
            if (save) {
                SvaDebug.saveProperties();
            }
        }
        String value = properties.getProperty(name);
        if (debugProps == null) {
            debugProps = new HashMap<String, String>();
        }
        debugProps.put(name, value);
        return value;
    }

    private static String getprop(String name, String defaultValue) {
        return SvaDebug.getprop(name, defaultValue, false);
    }

    private static Integer getprop(String name, int defaultValue) {
        return Integer.parseInt(SvaDebug.getprop(name, String.valueOf(defaultValue)));
    }

    private static Boolean getprop(String name, boolean defaultValue) {
        return Boolean.parseBoolean(SvaDebug.getprop(name, String.valueOf(defaultValue)));
    }

    public static void setVolatileProp(String name, String value) throws Exception {
        if (name.equals("sas.fault.input_param_validation")) {
            SAS_FAULT_INPUT_PARAM_VALIDATION = Boolean.valueOf(value);
        } else if (name.equals("dpe.fault.add.nth.event.listener")) {
            DPE_FAULT_ADD_NTH_EVENT_LISTENER = Integer.valueOf(value);
        } else if (name.equals("dpe.fault.remove.nth.event.listener")) {
            DPE_FAULT_REMOVE_NTH_EVENT_LISTENER = Integer.valueOf(value);
        } else if (name.equals("member.induce_remote_failure_script")) {
            MEMBER_INDUCE_REMOTE_FAILURE_SCRIPT = value;
        } else {
            throw new Exception("Unknown or unsettable debug property " + name);
        }
    }

    public static synchronized void setProp(String name, String value) throws Exception {
        SvaDebug.loadProperties();
        properties.setProperty(name, value);
        SvaDebug.setVolatileProp(name, value);
        SvaDebug.saveProperties();
    }

    public static void injectFault(AtomicInteger count, int max, String faultName) throws Exception {
        if (max > 0 && max < count.incrementAndGet()) {
            count.set(0);
            throw new Exception(faultName + " injected");
        }
    }

    public static String listProperties() {
        return SvaUtilities.listProperties(debugProps, "VSA Debug Properties settable via " + DEBUG_PROPERTIES_PATH);
    }

    static {
        properties = null;
    }
}

