/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.PhysicalVolume;
import com.vmware.sva.common.StorageClusterConfig;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaVersion;
import com.vmware.sva.common.util.SystemCommand;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SvaUtilities {
    private SvaUtilities() {
    }

    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="This method is intended to return null")
    public static <T> T[] copyArray(T[] array) {
        return array != null ? Arrays.copyOf(array, array.length) : null;
    }

    public static boolean isEnumClass(Class<?> cl) {
        do {
            if (!cl.isEnum()) continue;
            return true;
        } while ((cl = cl.getSuperclass()) != null);
        return false;
    }

    public static String listProperties(Map<String, String> props, String header) {
        StringBuilder result = new StringBuilder();
        result.append(header + "\n");
        TreeSet<String> sortedSet = new TreeSet<String>(props.keySet());
        for (String name : sortedSet) {
            result.append(String.format("%s=%s\n", name, props.get(name)));
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static Map<Integer, InetAddress> getZkServerMap(Properties configProperties) throws UnknownHostException {
        Set<String> pNames = configProperties.stringPropertyNames();
        HashMap<Integer, InetAddress> servers = new HashMap<Integer, InetAddress>();
        for (String name : pNames) {
            if (!name.contains("server.")) continue;
            String[] s = name.split("\\.");
            servers.put(Integer.valueOf(s[1]), InetAddress.getByName(configProperties.getProperty(name)));
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getZkServerAddresses() throws IOException {
        FileReader confFile = new FileReader(SvaConstants.SVA_ZK_PROPERTIES_FILE);
        Properties zkProp = new Properties();
        try {
            zkProp.load(confFile);
        }
        finally {
            confFile.close();
        }
        Set<String> pNames = zkProp.stringPropertyNames();
        ArrayList<String> servers = new ArrayList<String>();
        for (String name : pNames) {
            if (!name.contains("server.")) continue;
            servers.add(zkProp.getProperty(name));
        }
        return servers;
    }

    public static String formatDevice(String device) {
        assert (device != null);
        return "/dev/" + device;
    }

    public static String[] getAttributeFromStdout(String attribute, String delimiter, String ... command) throws Exception {
        String line;
        if (delimiter == null) {
            delimiter = " ";
        }
        String output = SystemCommand.executePlatformCommand(command);
        if (attribute == null) {
            return output.trim().split(delimiter);
        }
        String[] outStr = null;
        BufferedReader br = new BufferedReader(new StringReader(output));
        while ((line = br.readLine()) != null) {
            if (!line.contains(attribute)) continue;
            outStr = line.split(delimiter);
            break;
        }
        if (outStr == null || outStr.length == 0) {
            throw new Exception("getAttributeFromStdout: attribute not found");
        }
        return outStr;
    }

    public static String[] getAttributeFromFile(String attribute, String delimiter, String file) throws Exception {
        String[] outStr = null;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            if (delimiter == null) {
                delimiter = " ";
            }
            if (attribute == null) {
                String value = br.readLine();
                outStr = value != null ? value.split(delimiter) : null;
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(attribute)) continue;
                    outStr = line.split(delimiter);
                    break;
                }
                if (outStr == null) {
                    throw new Exception("getAttributeFromFile: attribute not found");
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Unable to get attribute: " + e.getMessage());
        }
        finally {
            br.close();
        }
        return outStr;
    }

    public static String getLvmAttribute(String utility, String name, String attribute) throws Exception {
        return SystemCommand.executePlatformCommand(utility, name, "--noheadings", "--nosuffix", "--units", "B", "--options", attribute).trim();
    }

    public static void activateVolumeGroup(String vgname) throws Exception {
        SystemCommand.executePlatformCommand("/sbin/vgchange", "-a", "y", vgname);
    }

    private static boolean arePvsSameSize(List<PhysicalVolume> pvs) {
        long firstSize = pvs.get(0).getSize();
        for (PhysicalVolume pv : pvs) {
            if (pv.getSize() == firstSize) continue;
            return false;
        }
        return true;
    }

    public static void resizePhysicalVolumes(List<PhysicalVolume> pvs, boolean setSize) throws Exception {
        assert (pvs != null);
        boolean pvsAreSameSize = SvaUtilities.arePvsSameSize(pvs);
        if (setSize && !pvsAreSameSize) {
            for (PhysicalVolume pv : pvs) {
                pv.resize(pv.getSize());
            }
        } else {
            ArrayList<String> pvCommand = new ArrayList<String>();
            pvCommand.add("/sbin/pvresize");
            if (setSize && pvsAreSameSize) {
                pvCommand.add("--setphysicalvolumesize");
                pvCommand.add(String.valueOf(pvs.get(0).getSize()) + "K");
            }
            for (PhysicalVolume pv : pvs) {
                pvCommand.add(pv.getName());
            }
            SystemCommand.executePlatformCommand(SvaConstants.PLATFORM_PVRESIZE_COMMAND_TIMEOUT, pvCommand.toArray(new String[pvCommand.size()]));
        }
    }

    public static void resizePhysicalVolume(PhysicalVolume pv, long size) throws Exception {
        assert (pv != null);
        assert (size >= 0L);
        ArrayList<String> pvCommand = new ArrayList<String>();
        pvCommand.add("/sbin/pvresize");
        if (size > 0L) {
            pvCommand.add("--setphysicalvolumesize");
            pvCommand.add(String.valueOf(size) + "K");
        }
        pvCommand.add(pv.getName());
        SystemCommand.executePlatformCommand(pvCommand.toArray(new String[pvCommand.size()]));
    }

    public static void deleteFiles(File ... files) throws IOException {
        for (File file : files) {
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    SvaUtilities.deleteFiles(file.listFiles());
                }
                if (file.delete()) continue;
                throw new IOException("Could not delete " + file.getName());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String filename, String value) throws IOException {
        FileWriter fw = new FileWriter(filename);
        try {
            fw.write(value);
        }
        finally {
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConsoleBanner(InetAddress frontEndAddress, StorageClusterConfig scConfig, Logger logger) {
        String clusterIp = null;
        StringBuilder msg = new StringBuilder("Welcome to VSA " + SvaVersion.getVersion() + "  Server: " + frontEndAddress.getHostAddress());
        if (scConfig != null) {
            clusterIp = scConfig.getMgmtInterface().getIpAddress().getHostAddress();
            msg.append("  Cluster: " + clusterIp);
            try {
                SvaUtilities.writeToFile(SvaConstants.SVA_CLUSTER_IP, clusterIp);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to write the cluster IP to " + SvaConstants.SVA_CLUSTER_IP);
            }
        } else {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(new File(SvaConstants.SVA_CLUSTER_IP)));
                clusterIp = br.readLine();
                if (clusterIp != null) {
                    msg.append("  Cluster: " + clusterIp);
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to read the cluster IP from " + SvaConstants.SVA_CLUSTER_IP);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close the cluster IP file " + SvaConstants.SVA_CLUSTER_IP);
                }
            }
        }
        msg.append("\n\n\n");
        try {
            clusterIp = "/etc/issue";
            SvaUtilities.writeToFile(clusterIp, msg.toString());
            clusterIp = "/etc/issue.net";
            SvaUtilities.writeToFile(clusterIp, msg.toString());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to write the cluster IP to " + clusterIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToBytes(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }
}

