/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import com.vmware.sva.common.TaskState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.UUID;

@SerialMinorVersion(value=2)
public class TaskStatus
extends AbstractSerializable {
    private UUID taskId;
    private final Date startTime;
    private final Date completionTime;
    private final double progress;
    private final Date statusTime;
    private final TaskState state;
    private final Exception failureException;
    private final Object result;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus(UUID taskId, Date startTime, Date completionTime, double progress, Date statusTime, TaskState state, Exception failureException, Object result) {
        if (taskId == null || startTime == null || statusTime == null || state == null) {
            throw new NullPointerException();
        }
        if (progress < 0.0 || progress > 1.0) {
            throw new IllegalArgumentException("Illegal value for progress: " + progress);
        }
        if (failureException != null && result != null) {
            throw new IllegalArgumentException("The failureException and result arguments cannot both be non-null");
        }
        TaskStatus taskStatus = this;
        synchronized (taskStatus) {
            this.taskId = taskId;
        }
        this.startTime = TaskStatus.copyDate(startTime);
        this.completionTime = TaskStatus.copyDate(completionTime);
        this.progress = progress;
        this.statusTime = TaskStatus.copyDate(statusTime);
        this.state = state;
        this.failureException = failureException;
        this.result = result;
    }

    public synchronized UUID getTaskId() {
        return this.taskId;
    }

    public Date getStartTime() {
        return TaskStatus.copyDate(this.startTime);
    }

    public Date getCompletionTime() {
        return TaskStatus.copyDate(this.completionTime);
    }

    public double getProgress() {
        return this.progress;
    }

    public Date getStatusTime() {
        return TaskStatus.copyDate(this.statusTime);
    }

    public TaskState getState() {
        return this.state;
    }

    public Exception getFailureException() {
        return this.failureException;
    }

    public Object getResult() {
        return this.result;
    }

    private static Date copyDate(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields(this, TaskStatus.class, in);
        if (fields != null) {
            ObjectInputStream.GetField getField = fields.getFieldAccessor();
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    TaskStatus taskStatus = this;
                    synchronized (taskStatus) {
                        this.taskId = (UUID)getField.get("taskID", null);
                        break;
                    }
                }
                default: {
                    throw new RuntimeException("Unexpected version: " + fields.getSerialMinorVersion());
                }
            }
        }
    }
}

