/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.LogicalVolume;
import com.vmware.sva.common.PhysicalVolume;
import com.vmware.sva.common.SvaUtilities;
import java.util.ArrayList;
import java.util.List;

public class VolumeGroup
extends AbstractSerializable {
    private final String name;
    private String uuid;
    private long size;
    private List<PhysicalVolume> physicalVolumes;
    private List<LogicalVolume> logicalVolumes;
    private static final long serialVersionUID = 1L;

    public VolumeGroup(String name, boolean includeVolumeInfo) throws Exception {
        this.name = name;
        SvaUtilities.activateVolumeGroup(name);
        String[] attributes = new String[]{"uuid", "size"};
        StringBuilder sb = new StringBuilder();
        for (String a : attributes) {
            sb.append(a + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String options = this.getVolumeGroupAttribute(sb.toString()).replaceAll("\\b\\s{2,}\\b", " ");
        String[] values = options.split(" ");
        if (values.length != attributes.length) {
            throw new Exception("Unable to construct a VolumeGroup object");
        }
        this.uuid = values[0];
        this.size = Long.valueOf(values[1]) / 1024L;
        if (includeVolumeInfo) {
            this.logicalVolumes = this.getLogicalVolumesList();
            this.physicalVolumes = this.getPhysicalVolumesList();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public long getSize() {
        return this.size;
    }

    public List<LogicalVolume> getLogicalVolumes() {
        return this.logicalVolumes;
    }

    public List<PhysicalVolume> getPhysicalVolumes() {
        return this.physicalVolumes;
    }

    public long getCurrentSize() throws Exception {
        Float size = Float.valueOf(this.getVolumeGroupAttribute("size"));
        size = Float.valueOf(size.floatValue() / 1024.0f);
        return size.longValue();
    }

    public long getFreeSpace() throws Exception {
        Float free = Float.valueOf(this.getVolumeGroupAttribute("free"));
        free = Float.valueOf(free.floatValue() / 1024.0f);
        return free.longValue();
    }

    public long getUsedSpace() throws Exception {
        long free;
        long size = this.getSize();
        return size >= (free = this.getFreeSpace()) ? size - free : 0L;
    }

    public long getExtentSize() throws Exception {
        return Long.valueOf(this.getVolumeGroupAttribute("extent_size")) / 1024L;
    }

    public long getExtentCount() throws Exception {
        return Long.valueOf(this.getVolumeGroupAttribute("extent_count"));
    }

    public long getFreeExtents() throws Exception {
        return Long.valueOf(this.getVolumeGroupAttribute("free_count"));
    }

    public List<LogicalVolume> getLogicalVolumesList() throws Exception {
        ArrayList<LogicalVolume> lvs = null;
        String lvList = this.getVolumeGroupAttribute("lv_name");
        if (!lvList.isEmpty()) {
            String[] lvNames;
            lvs = new ArrayList<LogicalVolume>();
            for (String lvName : lvNames = lvList.split("\n")) {
                lvs.add(new LogicalVolume(this.name, lvName.trim()));
            }
        }
        return lvs;
    }

    public List<PhysicalVolume> getPhysicalVolumesList() throws Exception {
        ArrayList<PhysicalVolume> pvs = null;
        String pvList = this.getVolumeGroupAttribute("pv_name");
        if (!pvList.isEmpty()) {
            String[] pvNames;
            pvs = new ArrayList<PhysicalVolume>();
            for (String pv : pvNames = pvList.split("\n")) {
                pvs.add(new PhysicalVolume(pv.trim()));
            }
        }
        return pvs;
    }

    public void resize(boolean setSize) throws Exception {
        if (this.physicalVolumes != null && this.physicalVolumes.size() != 0) {
            SvaUtilities.resizePhysicalVolumes(this.physicalVolumes, setSize);
            this.size = this.getCurrentSize();
        }
    }

    private String getVolumeGroupAttribute(String attribute) throws Exception {
        return SvaUtilities.getLvmAttribute("/sbin/vgs", this.name, attribute);
    }
}

