/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common.util;

import com.vmware.sva.common.NetConfigProtocol;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.NetworkState;
import com.vmware.sva.common.PseudoSVAPathUtil;
import com.vmware.sva.common.PseudoSvaClusterMetadata;
import com.vmware.sva.common.PseudoSvaPasswordInfo;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.util.UnixCryptEmulator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class PseudoSvaUtility {
    private static final Logger logger = Logger.getLogger(PseudoSvaUtility.class.getName());
    private static final String SYS_PROP_COMMAND = "command";
    private static final String SYS_PROP_COMMAND_VALUE_CLEANUP = "cleanup";
    private static final String SYS_PROP_COMMAND_VALUE_VERIFY_CLEANUP = "verify-cleanup";
    private static final String SYS_PROP_CONFIG_XML = "configXml";
    private static final String SYS_PROP_TIMEOUT = "timeout";
    private static final String DATEFORMAT = "yyyy-MM-dd-HH-mm-ss-SSS";
    public static final String PASSWORD_CHARSET = "ISO-8859-1";

    public static String getHostname(String ipAddr) throws UnknownHostException {
        if (ipAddr == null) {
            return InetAddress.getLocalHost().getHostName();
        }
        return InetAddress.getByName(ipAddr).getHostName();
    }

    public static String[] getDnsServers() throws IOException {
        InitialDirContext ctx;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new IOException("Unable to read DNS information: " + e.getMessage(), e);
        }
        String dnsStr = null;
        try {
            dnsStr = (String)ctx.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException e) {
            throw new IOException("Unable to read DNS information: " + e.getMessage(), e);
        }
        if (dnsStr == null) {
            return new String[0];
        }
        String[] dnsServers = dnsStr.trim().split(" ");
        for (int i = 0; i < dnsServers.length; ++i) {
            try {
                dnsServers[i] = new URI(dnsServers[i]).getHost();
                continue;
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to read DNS information: " + e.getMessage(), e);
            }
        }
        return dnsServers;
    }

    public static String getDomainName() throws UnknownHostException {
        String fqdn = null;
        fqdn = InetAddress.getLocalHost().getHostName();
        int pos = fqdn.indexOf(".");
        if (pos == -1 || pos + 1 == fqdn.length()) {
            return "";
        }
        return fqdn.substring(pos + 1);
    }

    public static NetworkInterface getNetworkInterface(String ipAddr) throws UnknownHostException, SocketException {
        NetworkInterface ret = null;
        InetAddress findIP = InetAddress.getByName(ipAddr);
        if (findIP == null) {
            throw new UnknownHostException("Invalid IP " + ipAddr);
        }
        java.net.NetworkInterface net = java.net.NetworkInterface.getByInetAddress(findIP);
        if (net == null) {
            throw new UnknownHostException("Invalid IP " + ipAddr);
        }
        List<InterfaceAddress> addresses = net.getInterfaceAddresses();
        for (InterfaceAddress address : addresses) {
            InetAddress inetAddress = address.getAddress();
            System.out.println(inetAddress.getHostAddress());
            if (!(inetAddress instanceof Inet4Address) || !inetAddress.getHostAddress().equals(ipAddr)) continue;
            NetworkState state = net.isUp() ? NetworkState.UP : NetworkState.DOWN;
            ret = new NetworkInterface(inetAddress, address.getNetworkPrefixLength(), NetConfigProtocol.NONE, state, net.getName());
            break;
        }
        return ret;
    }

    public static String getPseudoSvaVersion() throws Exception {
        String file = SvaConstants.PSEUDOSVA_VERSIONFILE;
        FileReader fin = new FileReader(file);
        BufferedReader bin = new BufferedReader(fin);
        String line = bin.readLine();
        if (line == null) {
            throw new Exception("Missing entry for version in " + file);
        }
        String[] version = line.split("-");
        try {
            bin.close();
        }
        catch (IOException ie) {
            logger.log(Level.WARNING, "Ignoring Exception - failed to close BufferedReader for " + file, bin);
        }
        return version[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyCleanup() {
        String timeOutStr = System.getProperty(SYS_PROP_TIMEOUT, "60");
        int timeOut = Integer.parseInt(timeOutStr);
        boolean condSatisfied = false;
        while (timeOut > 0 && !condSatisfied) {
            FileReader reader = null;
            String value = null;
            try {
                reader = new FileReader(SvaConstants.SvaPropertiesPath);
                Properties properties = new Properties();
                properties.load(reader);
                value = properties.getProperty("pseudosva.destroy");
            }
            catch (Exception ex) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                condSatisfied = true;
            }
            if (condSatisfied) continue;
            --timeOut;
            try {
                System.out.print(".");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        System.out.println("\n");
        return condSatisfied;
    }

    private static void printUsage() {
        System.err.println("Usage:");
        System.err.println("- cleanup: -Dcommand=cleanup -DconfigXml=<config xml file>");
        System.err.println("- verify-cleanup: -Dcommand=verify-cleanup -Dtimeout=<timeout in sec> -DconfigXml=<config xml file>");
    }

    public static void main(String[] args) throws Exception {
        String configXml;
        String command = System.getProperty(SYS_PROP_COMMAND);
        if (command == null) {
            System.err.println("The command is not specified.");
            PseudoSvaUtility.printUsage();
            System.exit(1);
        }
        if ((configXml = System.getProperty(SYS_PROP_CONFIG_XML)) == null) {
            System.err.println("The config XML file is not specified.");
            PseudoSvaUtility.printUsage();
            System.exit(1);
        }
        PseudoSVAPathUtil.setPsvaConfigPath(configXml);
        System.setProperty("isPseudoSVA", Boolean.TRUE.toString());
        if (command.equals(SYS_PROP_COMMAND_VALUE_CLEANUP)) {
            SvaConstants.setProp("pseudosva.destroy", "true");
        } else if (command.equals(SYS_PROP_COMMAND_VALUE_VERIFY_CLEANUP)) {
            boolean condSatisfied = PseudoSvaUtility.verifyCleanup();
            if (!condSatisfied) {
                System.exit(1);
            }
        } else {
            PseudoSvaUtility.printUsage();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void ZipFiles(String zipFile, String dir, String filePattern, String[] additionalFiles) throws IOException {
        File outFile;
        if (filePattern == null) {
            filePattern = ".*";
        }
        if ((outFile = new File(zipFile)).exists()) {
            logger.log(Level.INFO, "Removing old bundle " + zipFile);
            if (!outFile.delete()) {
                logger.log(Level.WARNING, "Failed to delete " + outFile.getAbsolutePath());
            }
        }
        logger.log(Level.INFO, "Creating diagnostic bundle " + zipFile);
        FileOutputStream dest = new FileOutputStream(zipFile);
        CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(checksum));
        out.setMethod(8);
        out.setLevel(9);
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        String timeStr = sdf.format(Calendar.getInstance().getTime());
        String prefixDir = "vcs-" + timeStr;
        File d = new File(dir);
        File[] files = d.listFiles();
        String curFileStr = null;
        String outFileStr = outFile.getCanonicalPath();
        for (File file : files) {
            try {
                curFileStr = file.getCanonicalPath();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed get canonical path for " + file.getAbsolutePath(), e);
                continue;
            }
            if (!file.isFile() || !Pattern.matches(filePattern, file.getName()) || curFileStr.equals(outFileStr)) continue;
            PseudoSvaUtility.addFiletoZip(curFileStr, out, prefixDir);
        }
        for (String f : additionalFiles) {
            if (!new File(f).isFile()) continue;
            PseudoSvaUtility.addFiletoZip(f, out, prefixDir);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close " + zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addFiletoZip(String path, ZipOutputStream out, String prefixDir) {
        int bufSize = 4096;
        FileInputStream fi = null;
        boolean ret = false;
        try {
            fi = new FileInputStream(path);
            File f = new File(path);
            ZipEntry entry = new ZipEntry(prefixDir + "/" + f.getName());
            logger.log(Level.FINE, "Zip file entry " + prefixDir + "/" + f.getName());
            byte[] data = new byte[bufSize];
            out.putNextEntry(entry);
            int bytes = 0;
            while ((bytes = fi.read(data, 0, bufSize)) != -1) {
                out.write(data, 0, bytes);
            }
            logger.log(Level.FINE, "Added " + path);
            ret = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to Zip file " + path, e);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to close " + path);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMetaData(PseudoSvaClusterMetadata newMetadata, boolean passOverwrite) throws IOException {
        ObjectOutputStream out = null;
        PseudoSvaClusterMetadata pMetadata = newMetadata;
        try {
            PseudoSvaClusterMetadata myMetadata;
            if (!passOverwrite && (myMetadata = PseudoSvaUtility.getMetaData()) != null && newMetadata.getPasswords().size() == 0) {
                pMetadata = new PseudoSvaClusterMetadata(myMetadata.getPasswords(), newMetadata.getClusterID());
            }
            FileOutputStream f = new FileOutputStream(SvaConstants.PSEUDOSVA_METADATA_FILE);
            out = new ObjectOutputStream(f);
            SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
            String timeStr = sdf.format(Calendar.getInstance().getTime());
            out.writeObject(timeStr);
            out.writeObject(pMetadata);
            logger.log(Level.INFO, "Updated Metadata written on " + timeStr);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Ignoring exception - Unable to close output stream", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PseudoSvaClusterMetadata getMetaData() throws IOException {
        ObjectInputStream in = null;
        PseudoSvaClusterMetadata pMetadata = null;
        try {
            FileInputStream f = new FileInputStream(SvaConstants.PSEUDOSVA_METADATA_FILE);
            in = new ObjectInputStream(f);
            try {
                String timeStr = (String)in.readObject();
                pMetadata = (PseudoSvaClusterMetadata)in.readObject();
                logger.log(Level.INFO, "Retrieved Metadata written on " + timeStr);
            }
            catch (ClassNotFoundException c) {
                logger.log(Level.SEVERE, "Unable to read meta data", c);
                throw new IOException("Failed to read meta data " + c.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ie) {
                    logger.log(Level.WARNING, "Ignoring exception - Unable to close output stream", ie);
                }
            }
        }
        return pMetadata;
    }

    public static boolean isMetaDataInitialized() {
        File f = new File(SvaConstants.PSEUDOSVA_METADATA_FILE);
        return f.exists();
    }

    public static byte[] hashPassword(byte[] password) throws Exception {
        return UnixCryptEmulator.crypt(password);
    }

    public static void initializeMetadata() throws Exception {
        byte[] pass = SvaConstants.SVAPASSWD.getBytes(PASSWORD_CHARSET);
        byte[] hash = PseudoSvaUtility.hashPassword(pass);
        HashMap<String, PseudoSvaPasswordInfo> psvaPasswdHashes = new HashMap<String, PseudoSvaPasswordInfo>();
        psvaPasswdHashes.put(SvaConstants.SVAADMIN, new PseudoSvaPasswordInfo(SvaConstants.SVAADMIN, hash));
        PseudoSvaClusterMetadata mdata = new PseudoSvaClusterMetadata(psvaPasswdHashes, null);
        PseudoSvaUtility.writeMetaData(mdata, true);
        PseudoSvaUtility.zeroOutCachedBytes(pass);
        PseudoSvaUtility.zeroOutCachedBytes(hash);
    }

    public static byte[] rehashPassword(String user, byte[] password) throws Exception {
        PseudoSvaClusterMetadata metadata = PseudoSvaUtility.getMetaData();
        HashMap<String, PseudoSvaPasswordInfo> pMap = metadata.getPasswords();
        PseudoSvaPasswordInfo pInfo = pMap.get(user);
        if (pInfo == null) {
            logger.log(Level.WARNING, "User not present " + user);
            throw new Exception("Invalid user name or password");
        }
        byte[] pass = pInfo.getCurrentPasswordHash();
        byte[] salt = Arrays.copyOfRange(pass, 0, 2);
        return UnixCryptEmulator.crypt(password, salt);
    }

    public static boolean verifyPassword(String user, byte[] passwordHash) throws Exception {
        PseudoSvaClusterMetadata metadata = PseudoSvaUtility.getMetaData();
        HashMap<String, PseudoSvaPasswordInfo> pMap = metadata.getPasswords();
        PseudoSvaPasswordInfo pInfo = pMap.get(user);
        if (pInfo == null) {
            logger.log(Level.WARNING, "User not present " + user);
            throw new Exception("Invalid user name or password");
        }
        byte[] currPass = pInfo.getCurrentPasswordHash();
        return Arrays.equals(passwordHash, currPass);
    }

    public static void zeroOutCachedBytes(byte[] b) {
        Arrays.fill(b, (byte)0);
    }
}

