#!/usr/bin/env python
# Copyright (c) 2015
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
#     The above copyright notice and this permission notice shall be
#     included in all copies or substantial portions of the Software.
#
#     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#     EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#     OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#     NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
#     HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
#     WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#     FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#     OTHER DEALINGS IN THE SOFTWARE.
# Version 6.0.0

import os
import errno
import sys
import platform
import subprocess
import xml.etree.ElementTree as ET
import shutil
import getopt
import envSetting

env = envSetting.EnvSetting()
def executeDirCliCmd() :
    print """Executing dir-cli command"""
    cmd = [env.vmdir,"trustedcert", "publish", "--cert", env.root_cert]
    print("Enter Password:")
    cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
    return cmd_out.communicate() [0]
#run the stsInstaller
def executeStsInstaller() :
   print "Executing STSInstaller"
   cmd = [env.JAVA, "-cp", env.CLASSPATH, env.logdir,"com.vmware.identity.installer.STSInstaller", "--install", "--root-cert-path", env.rootcertPath,
           "--cert-path",  env.certPath, "--private-key-path", env.privateKeyPath, "--retry-count", "10",
           "--retry-interval", "30", ]
   cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
   return cmd_out.communicate() [0]

#run the opensslcommand
def opensslCmd(arugments):
   print "Executing openssl command"
   cmd = [env.openssl_exe]
   cmd += arugments
   cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
   return cmd_out.communicate() [0]

#run cert tool command
def certoolCmd(arguments):
    print "executing certTool command"
    cmd = [env.certool_exe]
    cmd += arguments
    cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
    return cmd_out.communicate()[0]

#create a directory
def createdir() :
    try :
        os.makedirs(env.ha_folder)
    except OSError as exc:
        if exc.errno == errno.EEXIST and os.path.isdir(env.ha_folder) :
            pass
        else :
            raise

#modify the hostname file
def mod_hostnamefile() :
    print "Modifying hostname.txt"
    with open(env.hostname_file,"w") as fd:
        fd.write(env._LB_FQDN)

def mod_serverxmlfile() :
    print "modifying server.xml"
    tree = ET.parse(env.server_xml_file)
    root = tree.getroot()
    for entry in root:
        if entry.tag == 'Service' and entry.attrib['name'] == 'Catalina' :
            for child in entry :
                if child.tag == 'Connector' and child.get("SSLEnabled") != None:
                    child.set('proxyName',env._LB_FQDN)
                    break

    tree.write(env.server_xml_file)

def stopService(name) :
    print "Executing StopService " + name
    if name == '--all' :
        cmd = [env.service_control_exe]
        cmd.append("--stop")
        cmd.append(name)
        cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
        return cmd_out.communicate()[0]
    else :
        if platform.system() == 'Windows':
            cmd = ['net','stop', name, '/Y']
            cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
            return cmd_out.communicate()[0]
        else :
            cmd = ['service',name, 'stop']
            cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
            return cmd_out.communicate()[0]

def startService(name) :

    if name == '--all' :
        print "Executing StartService " + name
        cmd = [env.service_control_exe]
        cmd.append("--start")
        cmd.append(name)
        cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
        return cmd_out.communicate()[0]
    else :
        if platform.system() == 'Windows':
            cmd = ['net','start', name]
            cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
            return cmd_out.communicate()[0]
        else :
            cmd = ['service',name, 'start']
            cmd_out = subprocess.Popen(cmd, stdout=subprocess.PIPE)
            return cmd_out.communicate()[0]

def waitForInput() :
    raw_input("Press enter to continue.")

# Print the usage
def usage() :
    print """Usage :  """
    print """ """
    print """ On Primary Node: """
    print """python gen-lb-cert.py --primary-node --lb-fqdn=<lb_fqdn> --password=<Password for certificate>"""
    print """ """
    print """ On Secondary Node:"""
    print """ """
    print """python gen-lb-cert.py --secondary-node --lb-fqdn=<lb-fqdn> --lb-cert-folder=<folder location> --sso-serversign-folder=<folder location> """
    print """ """
    print """ --cert-folder is the location of the folder on the local machine containing file from the /HA or c:\HA folder of the primary node"""
    print """ --sso-sign-folder is the location of the folder on the local machine containing files ssoserverSign.* files and ssoserverRoot.crt files from the primary node"""
    print """ """
    print """ 5.5 to 6.0 upgrade:"""
    print """ """
    print """python gen-lb-cert.py --upgrade --lb-fqdn=<lb-fqdn> --root-cert=<file location>"""
    print """ """

if __name__ == "__main__":

    try :
        opts, args = getopt.getopt(sys.argv[1:],"",["primary-node","secondary-node","upgrade","lb-fqdn=","lb-cert-folder=","sso-serversign-folder=","root-cert=","password="])
    except getopt.GetoptError as err:
        usage()
        sys.exit(1)

    if len(opts) == 0 :
        usage()
        sys.exit(1)

    for o,a in opts:
        if o == "--primary-node" :
            env.primary_node = True
        elif o == "--secondary-node" :
            env.secondary_node = True
        elif o == '--upgrade':
            env.upgrade = True
        elif o == "--lb-fqdn":
            env._LB_FQDN = a
        elif o == "--lb-cert-folder":
            env._lb_cert_folder = a
        elif o == "--sso-serversign-folder":
            env._sso_server_sign = a
        elif o == "--root-cert":
            env.root_cert = a
        elif o == "--password":
            env.cert_password = a
        else:
            print "Invalid parameter"
            usage()
            sys.exit(1)

    if env.primary_node == True and  env._LB_FQDN == '' :
        print " PRIMARY NODE"
        usage()
        exit(1)
    elif env.secondary_node == True and (env._LB_FQDN== '' or env._lb_cert_folder == '' or env._sso_server_sign == '') :
        print " SECONDARY NODE"
        usage()
        exit(1)
    elif env.upgrade == True and (env._LB_FQDN == '' or env.root_cert == '') :
        print " UPGRADE"
        usage()
        exit(1)
    else :
        if env.secondary_node == True:
            print """Please make sure that you have copied the contents from HA folder in Node 1 into"""
            print """the HA folder in the local node"""
            print """Please Make that you have copied the ssoserverSign.* files and ssoServerRoot.crt file from node 1"""
            waitForInput()

        #copy the root.cert from the vmca folder
        if env.primary_node == True:
            createdir()
            shutil.copyfile(env.srcfile,env.dstfile)

            args = ["--genkey", "--privkey="+env.lb_key_file, "--pubkey="+env.lb_key_pub_file, "--config="+env.certool_cfg]

            output = certoolCmd(args[0:])

            del args[:]
            args = ["--gencert","--priv="+env.lb_key_file,"--Name="+env._LB_FQDN,"--FQDN="+env._LB_FQDN,"--Hostname="+env._LB_FQDN,
                    "--cert="+env.lb_crt_file,"--server=localhost", "--config="+env.certool_cfg]
            output = certoolCmd(args[0:])
            print output

            del args[:]

            args = ["pkcs12","-export","-in", env.lb_crt_file, "-inkey", env.lb_key_file, "-out", env.lb_p12_file,
                        "-name", "ssoserver","-passout","pass:"+env.cert_password,"-CAfile",env.dstfile,"-caname","rootca"]
            output = opensslCmd(args[0:])

            del args[:]
            args = [ "rsa", "-in", env.lb_key_file, "-out", env.lb_rsa_key]
            output = opensslCmd(args[0:])


        #modify hostname.txt
        mod_hostnamefile()
        #modify server.xml
        mod_serverxmlfile()
        #update vmdir certificate files
        if env.primary_node == True:
            shutil.copyfile(env.lb_crt_file,env.vmdir_cert_file)
            shutil.copyfile(env.lb_key_file,env.vmdir_key_file)
        if env.secondary_node == True:
            env.lb_crt_file = os.path.join(env._lb_cert_folder,"lb.crt")
            env.lb_key_file = os.path.join(env._lb_cert_folder,"lb.key")
            shutil.copyfile(env.lb_crt_file,env.vmdir_cert_file)
            shutil.copyfile(env.lb_key_file,env.vmdir_key_file)
        #Replace the STS Signing cert from Primary Node
        if env.secondary_node == True:
            stopService(env.vmstsServicename)
            stopService(env.vmidmServicename)
            #update the licence
            if platform.system() == 'Windows':
                target_dir = os.path.join(env._VMWARE_CFG_DIR, "sso\\keys\\")
            else :
                target_dir =  "/etc/vmware-sso/keys/"
            shutil.copyfile(os.path.join(env._sso_server_sign,"ssoserverRoot.crt"), os.path.join(target_dir, "ssoserverRoot.crt" ))
            shutil.copyfile(os.path.join(env._sso_server_sign,"ssoserverSign.crt"), os.path.join(target_dir, "ssoserverSign.crt"))
            shutil.copyfile(os.path.join(env._sso_server_sign,"ssoserverSign.key"), os.path.join(target_dir, "ssoserverSign.key"))
            shutil.copyfile(os.path.join(env._sso_server_sign,"ssoserverSign.pub"), os.path.join(target_dir, "ssoserverSign.pub"))

            startService(env.vmidmServicename)
            # Execute STSInstalller
            executeStsInstaller()
            startService(env.vmstsServicename)
        if env.upgrade:
            executeDirCliCmd()
        stopService("--all")
        startService("--all")
        if env.primary_node == True:
            print "Copy the contents of the " + env.ha_folder + " to the other nodes"
            print """ Please copy the p12 file into the F5 loadbalancer"""
            print """ Please copy the lb_rsa.key file and lb.crt file into the Netscaler loadbalancer"""

