/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanMethodConfig;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.util.config.ConfigResponse;

public class ScanConfiguration {
    private ScanConfigurationCore _core;
    private boolean _isDefaultScan = false;
    private boolean _isSyncScan = false;

    public ScanConfiguration() {
        this._core = new ScanConfigurationCore();
    }

    public ScanConfiguration(ScanConfigurationCore core) {
        this._core = core;
    }

    public ScanConfigurationCore getCore() {
        return this._core;
    }

    public void setCore(ScanConfigurationCore core) {
        this._core = core;
    }

    public boolean getIsDefaultScan() {
        return this._isDefaultScan;
    }

    public void setIsDefaultScan(boolean b) {
        this._isDefaultScan = b;
    }

    public boolean isSyncScan() {
        return this._isSyncScan;
    }

    public void setIsSyncScan(boolean b) {
        this._isSyncScan = b;
    }

    public String[] getScanMethodNames() {
        ScanMethodConfig[] configs = this._core.getScanMethodConfigs();
        if (configs == null) {
            return new String[0];
        }
        String[] methods = new String[configs.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = configs[i].getMethodClass();
        }
        return methods;
    }

    public void setScanMethodConfig(ScanMethod scanMethod, ConfigResponse config) {
        try {
            ScanMethodConfig methodConfig = this._core.findScanMethodConfig(scanMethod);
            methodConfig.setConfig(config);
        }
        catch (IllegalArgumentException iae) {
            this._core.addScanMethodConfig(scanMethod, config);
        }
    }

    public ConfigResponse getScanMethodConfig(ScanMethod scanMethod) {
        ScanMethodConfig methodConfig = this._core.findScanMethodConfig(scanMethod);
        return methodConfig.getConfig();
    }

    public ConfigResponse getScanMethodConfig(String scanMethodName) {
        ScanMethodConfig methodConfig = this._core.findScanMethodConfig(scanMethodName);
        return methodConfig.getConfig();
    }

    public ServerSignature[] getServerSignatures() {
        return this._core.getServerSignatures();
    }

    public void setServerSignatures(ServerSignature[] serverSigs) {
        this._core.setServerSignatures(serverSigs);
    }

    public ConfigResponse getConfigResponse() {
        return this._core.getConfigResponse();
    }

    public void setConfigResponse(ConfigResponse configResponse) {
        this._core.setConfigResponse(configResponse);
    }

    public String toString() {
        if (this._core == null) {
            return "ScanConfiguration:NULL-CORE";
        }
        return "Sync scan: " + this.isSyncScan() + "\n" + "Default scan: " + this.getIsDefaultScan() + "\n" + this._core.toString();
    }

    public boolean equals(Object o) {
        if (this._core == null) {
            return false;
        }
        if (o instanceof ScanConfiguration) {
            return this._core.equals(((ScanConfiguration)o).getCore());
        }
        return false;
    }
}

