/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.Serializable;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.util.StringifiedException;

public class ScanMethodState
implements Serializable {
    private static final long serialVersionUID = -8762869412017148433L;
    private String methodClass;
    private StringifiedException[] exceptions;
    private AIServerValue[] servers;
    private String status;

    public ScanMethodState() {
    }

    public ScanMethodState(String methodClass) {
        this.setMethodClass(methodClass);
        this.setStatus("not yet started");
        this.setExceptions(null);
    }

    public String getMethodClass() {
        return this.methodClass;
    }

    public void setMethodClass(String methodClass) {
        this.methodClass = methodClass;
    }

    public StringifiedException[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(StringifiedException[] exceptions) {
        this.exceptions = exceptions;
    }

    public void addException(StringifiedException ex) {
        if (this.exceptions == null) {
            this.exceptions = new StringifiedException[]{ex};
        } else {
            StringifiedException[] newExceptions = new StringifiedException[this.exceptions.length + 1];
            System.arraycopy(this.exceptions, 0, newExceptions, 0, this.exceptions.length);
            newExceptions[newExceptions.length - 1] = ex;
            this.exceptions = newExceptions;
        }
    }

    public void addExceptions(Throwable[] throwables) {
        StringifiedException[] sExceptions = new StringifiedException[throwables.length];
        for (int i = 0; i < throwables.length; ++i) {
            sExceptions[i] = new StringifiedException(throwables[i]);
        }
        if (this.exceptions == null) {
            this.exceptions = sExceptions;
        } else {
            StringifiedException[] newExceptions = new StringifiedException[this.exceptions.length + sExceptions.length];
            System.arraycopy(this.exceptions, 0, newExceptions, 0, this.exceptions.length);
            System.arraycopy(sExceptions, 0, newExceptions, this.exceptions.length, sExceptions.length);
            this.exceptions = newExceptions;
        }
    }

    public AIServerValue[] getServers() {
        return this.servers;
    }

    public void setServers(AIServerValue[] servers) {
        this.servers = servers;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

