/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.autoinventory.AICompare;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanMethodState;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.util.StringUtil;
import org.hyperic.util.StringifiedException;

public class ScanState {
    private static HashMap installdirExcludes = new HashMap();
    private static List installdirExcludesPrefixes = new ArrayList();
    private static final Log _log = LogFactory.getLog(ScanState.class);
    private DateFormat dateFmt = DateFormat.getDateTimeInstance(3, 2);
    private ScanStateCore _core;
    private Map _scanMethods = null;
    private boolean _isDefaultScan = false;
    private boolean _isSyncScan = false;
    private static Comparator COMPARE_AIID;
    private static Comparator COMPARE_AUTH;

    public ScanState() {
        this._core = new ScanStateCore();
    }

    public ScanState(ScanStateCore core) {
        this._core = core;
    }

    public ScanStateCore getCore() {
        return this._core;
    }

    public void setCore(ScanStateCore core) {
        this._core = core;
    }

    public boolean getIsDefaultScan() {
        return this._isDefaultScan;
    }

    public void setIsDefaultScan(boolean b) {
        this._isDefaultScan = b;
    }

    public boolean isSyncScan() {
        return this._isSyncScan;
    }

    public void setIsSyncScan(boolean b) {
        this._isSyncScan = b;
    }

    public boolean getAreServersIncluded() {
        return this._core.getAreServersIncluded();
    }

    public void setAreServersIncluded(boolean b) {
        this._core.setAreServersIncluded(b);
    }

    public long getStartTime() {
        return this._core.getStartTime();
    }

    public String getStartTimeStr() {
        if (this.getStartTime() == 0L) {
            return "00/00/00 00:00:00";
        }
        return this.dateFmt.format(new Long(this.getStartTime()));
    }

    public void setStartTime(long startTime) {
        this._core.setStartTime(startTime);
    }

    public long getEndTime() {
        return this._core.getEndTime();
    }

    public String getEndTimeStr() {
        if (this.getEndTime() == 0L) {
            return "00/00/00 00:00:00";
        }
        return this.dateFmt.format(new Long(this.getEndTime()));
    }

    public void setEndTime(long endTime) {
        this._core.setEndTime(endTime);
    }

    public String getElapsedTimeStr() {
        long end = 0L;
        if (this.getStartTime() == 0L) {
            return StringUtil.formatDuration((long)0L);
        }
        end = this.getEndTime() == 0L ? new Date().getTime() : this.getEndTime();
        return StringUtil.formatDuration((long)(end - this.getStartTime()));
    }

    public boolean getIsDone() {
        return this._core.getIsDone();
    }

    public void setIsDone() {
        this._core.setIsDone(true);
    }

    public boolean getIsInterrupted() {
        return this._core.getIsInterrupted();
    }

    public void setIsInterrupted() {
        this._core.setIsInterrupted(true);
    }

    public StringifiedException getGlobalException() {
        return this._core.getGlobalException();
    }

    public void setGlobalException(Throwable _globalException) {
        this._core.setGlobalException(new StringifiedException(_globalException));
    }

    public void setScanMethods(String[] scanMethods) throws AutoinventoryException {
        ScanMethodState[] smStates = new ScanMethodState[scanMethods.length];
        for (int i = 0; i < scanMethods.length; ++i) {
            smStates[i] = new ScanMethodState();
            smStates[i].setMethodClass(scanMethods[i]);
        }
        this._core.setScanMethodStates(smStates);
        this.setupMethodHash();
    }

    protected void setupMethodHash() throws AutoinventoryException {
        this._scanMethods = new HashMap();
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        if (smStates == null) {
            return;
        }
        for (int i = 0; i < smStates.length; ++i) {
            ScanMethod method;
            String methodClass = smStates[i].getMethodClass();
            try {
                method = (ScanMethod)Class.forName(methodClass).newInstance();
            }
            catch (Exception e) {
                throw new AutoinventoryException(methodClass + ": error instantiating: " + e, e);
            }
            this._scanMethods.put(methodClass, method);
        }
    }

    public boolean completedOK() {
        return this._core.getIsDone() && !this.hasExceptions() && !this._core.getIsInterrupted();
    }

    public boolean hasExceptions() {
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        for (int i = 0; i < smStates.length; ++i) {
            StringifiedException[] exceptions = smStates[i].getExceptions();
            if (exceptions == null || exceptions.length <= 0) continue;
            return true;
        }
        return false;
    }

    public void initStartTime() {
        this._core.setStartTime(System.currentTimeMillis());
    }

    public void initEndTime() {
        this._core.setEndTime(System.currentTimeMillis());
    }

    public long getScanDuration() {
        long startTime = this._core.getStartTime();
        long endTime = this._core.getEndTime();
        if (endTime == 0L) {
            if (startTime == 0L) {
                return 0L;
            }
            return System.currentTimeMillis() - startTime;
        }
        return endTime - startTime;
    }

    public AIPlatformValue getPlatform() {
        return this._core.getPlatform();
    }

    public void setPlatform(AIPlatformValue platform) {
        this._core.setPlatform(platform);
    }

    public String getCertDN() {
        return this._core.getPlatform().getCertdn();
    }

    public void setCertDN(String certDN) {
        this._core.setCertDN(certDN);
    }

    public void addScanException(ScanMethod scanMethod, Throwable t) {
        ScanMethodState smState = this.findSMState("addScanException", scanMethod);
        smState.addException(new StringifiedException(t));
    }

    public void addScanExceptions(ScanMethod scanMethod, Throwable[] t) {
        ScanMethodState smState = this.findSMState("addScanException", scanMethod);
        smState.addExceptions(t);
    }

    public void setScanStatus(ScanMethod scanMethod, String status) {
        ScanMethodState smState = this.findSMState("addScanException", scanMethod);
        smState.setStatus(status);
    }

    public ScanMethodState[] getScanMethodStates() {
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        return smStates;
    }

    private AIServerValue getServerValue(Object o) {
        AIServerValue server = o instanceof AIServerValue ? (AIServerValue)o : (AIServerValue)((ServerResource)o).getResource();
        if (!server.cTimeHasBeenSet()) {
            server.setCTime(new Long(System.currentTimeMillis()));
        }
        return server;
    }

    private List excludeServers(List servers) {
        if (installdirExcludes.size() == 0) {
            return servers;
        }
        ArrayList includes = new ArrayList();
        for (int i = 0; i < servers.size(); ++i) {
            Object server = servers.get(i);
            String installpath = this.getServerValue(server).getInstallPath();
            boolean exclude = false;
            if (installdirExcludes.get(installpath) != null) continue;
            for (int j = 0; j < installdirExcludesPrefixes.size(); ++j) {
                String prefix = (String)installdirExcludesPrefixes.get(j);
                if (!installpath.startsWith(prefix)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            includes.add(server);
        }
        return includes;
    }

    public void addServers(ScanMethod scanMethod, List servers) {
        AIServerValue[] newServers;
        if ((servers = this.excludeServers(servers)).isEmpty()) {
            return;
        }
        ScanMethodState smState = this.findSMState("addServers", scanMethod);
        AIServerValue[] existingServers = smState.getServers();
        if (existingServers == null) {
            newServers = new AIServerValue[servers.size()];
            for (int i = 0; i < newServers.length; ++i) {
                newServers[i] = this.getServerValue(servers.get(i));
            }
        } else {
            ArrayList<AIServerValue> allServers = new ArrayList<AIServerValue>(Arrays.asList(existingServers));
            Iterator iterator = servers.iterator();
            while (iterator.hasNext()) {
                AIServerValue server = this.getServerValue(iterator.next());
                String identifier = server.getAutoinventoryIdentifier();
                boolean newIdentifier = true;
                for (AIServerValue existingServer : existingServers) {
                    if (!existingServer.getAutoinventoryIdentifier().equals(identifier)) continue;
                    newIdentifier = false;
                    break;
                }
                if (!newIdentifier) continue;
                allServers.add(server);
            }
            newServers = allServers.toArray(new AIServerValue[allServers.size()]);
        }
        smState.setServers(newServers);
    }

    public void printServers() {
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        for (int i = 0; i < smStates.length; ++i) {
            System.err.println("Detected by: " + smStates[i].getMethodClass());
            AIServerValue[] servers = smStates[i].getServers();
            for (i = 0; i < servers.length; ++i) {
                System.err.println("\t" + servers[i]);
            }
        }
    }

    public void printStackTraces() {
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        for (int i = 0; i < smStates.length; ++i) {
            StringifiedException[] exc = smStates[i].getExceptions();
            if (exc == null || exc.length <= 0) continue;
            System.err.println("Exceptions for method " + smStates[i].getMethodClass() + ":");
            for (int j = 0; j < exc.length; ++j) {
                System.err.println("\n" + exc[j].getStackTrace());
            }
        }
    }

    public void printFullStatus(PrintStream out) throws AutoinventoryException {
        StringifiedException globalEx = this._core.getGlobalException();
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        if (globalEx != null) {
            out.println("Severe failure: " + globalEx);
            out.println(globalEx.getStackTrace());
        }
        if (smStates == null) {
            out.println("scan not yet started.");
            return;
        }
        this.printMainStatus(out);
        for (int i = 0; i < smStates.length; ++i) {
            this.printMethodStatus(smStates[i], out);
        }
    }

    public void printMainStatus(PrintStream out) {
        out.print("\nOVERALL STATUS: ");
        String status = null;
        status = this._core.getIsInterrupted() ? "interrupted before normal completion" : (this._core.getIsDone() ? "completed" : "scan in progress");
        if (this._core.getGlobalException() != null) {
            status = status + ", however a general scanning error occurred";
        } else if (this.hasExceptions()) {
            status = status + " successfully, however one or more scan methods had errors";
        } else if (this._core.getIsDone()) {
            status = status + " successfully with no errors";
        }
        out.println(status);
        String duration = StringUtil.formatDuration((long)this.getScanDuration());
        out.println("Run time: " + duration);
        AIPlatformValue platform = this._core.getPlatform();
        if (platform != null) {
            out.println("\nPlatform Detected:");
            out.println("\t" + platform);
            out.println("\tIP addresses: " + StringUtil.arrayToString((Object[])platform.getAIIpValues()));
        } else {
            out.println("\nNo Platform Detected!");
        }
    }

    public void printMethodStatus(ScanMethodState smState, PrintStream out) throws AutoinventoryException {
        ScanMethod method = this.findScanMethod(smState.getMethodClass());
        out.println("\n" + method.getName() + ":");
        StringifiedException[] t = smState.getExceptions();
        String status = smState.getStatus();
        if (t != null && t.length > 0) {
            out.println("\t* SCAN FAILED: ");
            if (status != null) {
                out.println("\t* Last status before failure: " + status);
            } else {
                out.println("\t* No status message available.");
            }
            for (int i = 0; i < t.length; ++i) {
                out.println("\t* " + t[i].toString());
                out.println("\t* Stack Trace:");
                out.println(t[i].getStackTrace());
            }
        } else if (status == null) {
            out.println("\t* Status: unknown");
        } else {
            out.println("\t* Status: " + status);
        }
        AIServerValue[] servers = smState.getServers();
        if (servers == null || servers.length == 0) {
            out.println("\t* No Servers Detected");
        } else {
            out.println("\t* Detected Servers:");
            for (int i = 0; i < servers.length; ++i) {
                out.println("\t" + servers[i]);
            }
        }
        out.println("\n");
    }

    public String toString() {
        if (this._core == null) {
            return "[ScanState]";
        }
        return this._core.toString();
    }

    public Set getAllServers() throws AutoinventoryException {
        TreeSet<AIServerValue> allServers = new TreeSet<AIServerValue>(COMPARE_AIID);
        Map scanMethods = this.getScanMethodMap();
        Iterator iter = scanMethods.keySet().iterator();
        ArrayList smList = new ArrayList();
        while (iter.hasNext()) {
            smList.add(scanMethods.get(iter.next()));
        }
        Collections.sort(smList, COMPARE_AUTH);
        for (int i = 0; i < smList.size(); ++i) {
            ScanMethod method = (ScanMethod)smList.get(i);
            ScanMethodState smState = this.findSMState("getAllServers", method);
            String methodClass = smState.getMethodClass();
            AIServerValue[] servers = smState.getServers();
            if (servers == null) continue;
            for (int j = 0; j < servers.length; ++j) {
                if (allServers.add(servers[j]) || _log == null) continue;
                _log.info((Object)("Server not added because another scan method already detected it:" + servers[j]));
            }
        }
        HashMap<Integer, AIServerExtValue> mServers = new HashMap<Integer, AIServerExtValue>();
        for (Object e : allServers) {
            int hashCode;
            AIServerExtValue server;
            if (!(e instanceof AIServerExtValue) || !(server = (AIServerExtValue)e).getAutoEnable() || (hashCode = server.getMetricConnectHashCode()) == 0) continue;
            Integer key = new Integer(hashCode);
            AIServerExtValue cServer = (AIServerExtValue)mServers.get(key);
            if (cServer == null) {
                mServers.put(key, server);
                continue;
            }
            server.setAutoEnable(false);
            server.unsetMeasurementConfig();
            if (_log == null) continue;
            _log.info((Object)("Turning off AutoEnable for server " + server.getName() + " [" + server.getInstallPath() + "]" + ", has the same metric connect config as " + cServer.getName() + " [" + cServer.getInstallPath() + "]"));
        }
        return allServers;
    }

    protected ScanMethodState findSMState(String caller, ScanMethod scanMethod) {
        ScanMethodState[] smStates = this._core.getScanMethodStates();
        String smClassName = scanMethod.getClass().getName();
        for (int i = 0; i < smStates.length; ++i) {
            if (!smStates[i].getMethodClass().equals(smClassName)) continue;
            return smStates[i];
        }
        throw new IllegalArgumentException("Error finding smState: " + smClassName + ", caller=" + caller);
    }

    protected ScanMethod findScanMethod(String methodClass) throws AutoinventoryException {
        Map scanMethods = this.getScanMethodMap();
        ScanMethod m = (ScanMethod)scanMethods.get(methodClass);
        if (m != null) {
            return m;
        }
        throw new IllegalArgumentException("ScanMethod not found: " + methodClass);
    }

    private Map getScanMethodMap() throws AutoinventoryException {
        if (this._scanMethods == null) {
            this.setupMethodHash();
        }
        return this._scanMethods;
    }

    public boolean isSameState(ScanState other) throws AutoinventoryException {
        Set servers2;
        AIPlatformValue p2;
        AIPlatformValue p1 = this.getPlatform();
        if (!AICompare.compareAIPlatforms(p1, p2 = other.getPlatform())) {
            return false;
        }
        Set servers1 = this.getAllServers();
        return AICompare.compareAIServers(servers1, servers2 = other.getAllServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInstalldirExcludes() {
        File excludes = new File(AgentConfig.AGENT_CONF_DIR, "installdir.excludes");
        if (!excludes.exists()) {
            return;
        }
        FileReader is = null;
        try {
            String line;
            is = new FileReader(excludes);
            BufferedReader in = new BufferedReader(is);
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.endsWith("*")) {
                    line = line.substring(0, line.length() - 1);
                    installdirExcludesPrefixes.add(line);
                }
                installdirExcludes.put(line, Boolean.TRUE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        ScanState.loadInstalldirExcludes();
        COMPARE_AIID = new ServerComparator_AIID();
        COMPARE_AUTH = new ServerComparator_AuthLevel();
    }

    static class ServerComparator_AuthLevel
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof ScanMethod && o2 instanceof ScanMethod) {
                return ((ScanMethod)o2).getAuthorityLevel() - ((ScanMethod)o1).getAuthorityLevel();
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }

    static class ServerComparator_AIID
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof AIServerValue && o2 instanceof AIServerValue) {
                return ((AIServerValue)o2).getAutoinventoryIdentifier().compareTo(((AIServerValue)o1).getAutoinventoryIdentifier());
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }
}

