/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.appdef.shared.AIServiceTypeValue;
import org.hyperic.hq.bizapp.shared.lather.AiLatherValue;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;

public class AiServiceTypeLatherValue
extends AiLatherValue {
    private static final String PROP_CUSTOM_PROPERTIES = "customProperties";
    private static final String PROP_PROPERTIES = "properties";
    private static final String PROP_PLUGIN_CLASSES = "pluginClasses";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_NAME = "name";
    private static final String PROP_SERVICE_NAME = "serviceName";
    private static final String PROP_SERVER_ID = "serverId";
    private static final String PROP_MEASUREMENTS = "measurements";
    private static final String PROP_CONTROL_ACTIONS = "controlActions";
    private static final String PROP_PRODUCT_NAME = "productName";

    public AiServiceTypeLatherValue() {
    }

    public AiServiceTypeLatherValue(AIServiceTypeValue serviceType) {
        this.setByteAValue(PROP_CUSTOM_PROPERTIES, serviceType.getCustomProperties());
        this.setByteAValue(PROP_PLUGIN_CLASSES, serviceType.getPluginClasses());
        this.setByteAValue(PROP_PROPERTIES, serviceType.getProperties());
        this.setStringValue(PROP_DESCRIPTION, serviceType.getDescription());
        this.setStringValue(PROP_NAME, serviceType.getName());
        this.setStringValue(PROP_SERVICE_NAME, serviceType.getServiceName());
        this.setStringValue(PROP_PRODUCT_NAME, serviceType.getProductName());
        this.setIntValue(PROP_SERVER_ID, serviceType.getServerId());
        this.setByteAValue(PROP_MEASUREMENTS, serviceType.getMeasurements());
        String[] controlActions = serviceType.getControlActions();
        for (int i = 0; i < controlActions.length; ++i) {
            this.addStringToList(PROP_CONTROL_ACTIONS, controlActions[i]);
        }
    }

    public AIServiceTypeValue getAIServiceTypeValue() {
        AIServiceTypeValue serviceType = new AIServiceTypeValue();
        try {
            serviceType.setDescription(this.getStringValue(PROP_DESCRIPTION));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        serviceType.setName(this.getStringValue(PROP_NAME));
        serviceType.setServerId(this.getIntValue(PROP_SERVER_ID));
        serviceType.setServiceName(this.getStringValue(PROP_SERVICE_NAME));
        serviceType.setProductName(this.getStringValue(PROP_PRODUCT_NAME));
        try {
            serviceType.setCustomProperties(this.getByteAValue(PROP_CUSTOM_PROPERTIES));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        serviceType.setProperties(this.getByteAValue(PROP_PROPERTIES));
        serviceType.setPluginClasses(this.getByteAValue(PROP_PLUGIN_CLASSES));
        try {
            serviceType.setMeasurements(this.getByteAValue(PROP_MEASUREMENTS));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        try {
            serviceType.setControlActions(this.getStringList(PROP_CONTROL_ACTIONS));
        }
        catch (LatherKeyNotFoundException latherKeyNotFoundException) {
            // empty catch block
        }
        return serviceType;
    }

    public void validate() throws LatherRemoteException {
    }
}

