/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Properties;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.win32.EventLogNotification;
import org.hyperic.sigar.win32.EventLogRecord;

public abstract class Win32EventLogNotification
implements EventLogNotification {
    public static final String PROP_EVENT_LOGS = "platform.log_track.eventlogs";
    private static final String PROP_EVENT_FMT = "platform.log_track.eventfmt";
    private LogTrackPlugin plugin;
    private String format;

    public Win32EventLogNotification(LogTrackPlugin plugin) {
        this.plugin = plugin;
        this.format = plugin.getManagerProperty(PROP_EVENT_FMT);
        if (this.format != null) {
            plugin.getLog().debug((Object)("Using platform.log_track.eventfmt='" + this.format + "'"));
        }
    }

    public abstract boolean matches(EventLogRecord var1);

    public String getLogName() {
        String name = this.plugin.getTypeProperty("EVENT_LOG_NAME");
        if (name == null) {
            name = "Application";
        }
        return name;
    }

    private void setProp(Properties props, String key, String val) {
        if (val == null) {
            val = "-";
        }
        props.setProperty(key, val);
    }

    public void handleNotification(EventLogRecord record) {
        String msg;
        long generated = record.getTimeGenerated() * 1000L;
        if (this.format == null) {
            msg = record.getSource() + ": " + record.getMessage();
        } else {
            Properties props = new Properties();
            this.setProp(props, "computer", record.getComputerName());
            this.setProp(props, "event", String.valueOf(record.getEventId() & 0xFFFFL));
            this.setProp(props, "type", record.getEventTypeString());
            this.setProp(props, "log", record.getLogName());
            this.setProp(props, "message", record.getMessage());
            this.setProp(props, "source", record.getSource());
            String user = record.getUser();
            if (user == null) {
                user = "N/A";
            }
            this.setProp(props, "user", user);
            this.setProp(props, "category", record.getCategoryString());
            msg = Metric.translate(this.format, props);
        }
        TrackEvent event = this.plugin.newTrackEvent(generated, this.mapLogLevel(record.getEventType()), record.getLogName(), msg);
        if (event != null) {
            this.plugin.getManager().reportEvent(event);
        }
    }

    private int mapLogLevel(int level) {
        switch (level) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 0: 
            case 4: 
            case 8: 
            case 16: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown log level: " + level);
    }
}

