/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.StringTokenizer;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.jmx.MxNotificationListener;
import org.hyperic.util.config.ConfigResponse;

public class MxNotificationPlugin
extends LogTrackPlugin {
    public static final String PROP_NOTIFICATION_LISTENER_NAME = "NOTIFICATION_LISTENER_NAME";
    private MxNotificationListener listener = null;

    @Override
    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.listener = MxNotificationListener.getInstance(this);
        this.listener.add();
    }

    public String[] getMBeans() {
        String listenerName = this.getTypeProperty(PROP_NOTIFICATION_LISTENER_NAME);
        if (listenerName != null) {
            StringTokenizer tok = new StringTokenizer(listenerName, "\r\n");
            String[] mbeans = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                mbeans[i++] = tok.nextToken().trim();
            }
            return mbeans;
        }
        String objectName = this.getTypeProperty("OBJECT_NAME");
        if (objectName == null) {
            return new String[0];
        }
        return new String[]{objectName};
    }

    @Override
    public void shutdown() throws PluginException {
        if (this.listener != null) {
            this.listener.remove();
            this.listener = null;
        }
        super.shutdown();
    }

    @Override
    protected boolean supportsLogLevels() {
        return true;
    }
}

