/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.util.config.ConfigSchema;

public abstract class MxQuery {
    public static final String PROP_OBJECT_NAME = "OBJECT_NAME";
    public static final String PROP_ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    public static final String PROP_MBEAN_CLASS = "MBEAN_CLASS";
    public static final String PROP_OBJECT_NAME_FILTER = "OBJECT_NAME_FILTER";
    protected static final Properties EMPTY_PROPERTIES = new Properties();
    protected static final Log log = LogFactory.getLog(MxQuery.class);
    private Map attrs = new HashMap();
    private String name;
    private String url = null;
    private ServerDetector detector = null;
    protected ObjectName objectName;
    private Properties cprops;

    public void initialize() {
    }

    void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Properties getCustomProperties() {
        return this.cprops;
    }

    public String[] getAttributeNames() {
        String type = this.getResourceType();
        ConfigSchema schema = this.getServerDetector().getCustomPropertiesSchema(type);
        return schema.getOptionNames();
    }

    public void getAttributes(MBeanServerConnection mServer) throws PluginException {
        String[] names = this.getAttributeNames();
        if (names.length == 0) {
            this.cprops = EMPTY_PROPERTIES;
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            Object value;
            ObjectName objName;
            String name = names[i];
            int ix = name.lastIndexOf(58);
            if (ix == -1) {
                objName = this.getObjectName();
            } else {
                try {
                    objName = new ObjectName(name.substring(0, ix));
                }
                catch (MalformedObjectNameException e) {
                    throw new PluginException(name, e);
                }
                name = name.substring(ix + 1);
            }
            try {
                value = mServer.getAttribute(objName, name);
            }
            catch (Exception e) {
                log.debug((Object)("getAttribute(" + objName + ", " + name + ") failed"), (Throwable)e);
                continue;
            }
            if (value != null) {
                String stringValue = value instanceof Object[] ? Arrays.asList((Object[])value).toString() : value.toString();
                this.setAttribute(names[i], stringValue);
                continue;
            }
            log.debug((Object)("getAttribute(" + objName + ", " + name + ") returned null"));
            this.setAttribute(names[i], "Attribute was null");
        }
        this.cprops = new Properties();
        this.cprops.putAll((Map<?, ?>)this.attrs);
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        if (this.url == null) {
            return this.getParent().getURL();
        }
        return this.url;
    }

    public void setServerDetector(ServerDetector detector) {
        this.detector = detector;
    }

    public ServerDetector getServerDetector() {
        if (this.detector == null) {
            return this.getParent().getServerDetector();
        }
        return this.detector;
    }

    public void getAttributes(MBeanServerConnection mServer, ObjectName name, String[] attrs) throws PluginException {
        AttributeList mBeanAttrs;
        if (attrs.length == 0) {
            return;
        }
        try {
            mBeanAttrs = mServer.getAttributes(name, attrs);
        }
        catch (RemoteException e) {
            throw new PluginException("Cannot connect to server", e);
        }
        catch (InstanceNotFoundException e) {
            throw new PluginException("Cannot find MBean [" + name + "]", e);
        }
        catch (ReflectionException e) {
            throw new PluginException("MBean reflection exception", e);
        }
        catch (IOException e) {
            throw new PluginException("Cannot connect to server", e);
        }
        for (Attribute attr : mBeanAttrs) {
            Object value = attr.getValue();
            if (value == null) continue;
            this.setAttribute(attr.getName(), value.toString());
        }
    }

    public String getAttribute(String name) {
        return (String)this.attrs.get(name);
    }

    public String getAttribute(String name, String defval) {
        String attr = this.getAttribute(name);
        if (attr == null) {
            return defval;
        }
        return attr;
    }

    public void setAttribute(String name, String val) {
        this.attrs.put(name, val);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract String getQualifiedName();

    public abstract String getResourceType();

    public abstract String getIdentifier();

    public MxQuery getParent() {
        return null;
    }

    public boolean hasControl() {
        return true;
    }

    public Properties getResourceConfig() {
        return EMPTY_PROPERTIES;
    }

    public Properties getControlConfig() {
        return EMPTY_PROPERTIES;
    }
}

