/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.server.AgentConnectionListener;
import org.hyperic.hq.agent.server.AgentServerConnection;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.DefaultServerConnection;

class DefaultConnectionListener
extends AgentConnectionListener {
    private final Log log = LogFactory.getLog(DefaultConnectionListener.class);
    private ServerSocket listenSock = null;

    DefaultConnectionListener(AgentConfig cfg) {
        super(cfg);
    }

    @Override
    public void setup() throws AgentStartException {
        InetAddress addr;
        int listenPort = this.getConfig().getListenPort();
        try {
            addr = this.getConfig().getListenIpAsAddr();
        }
        catch (UnknownHostException exc) {
            throw new AgentStartException("Failed to get IP as address for listening", exc);
        }
        try {
            this.listenSock = new ServerSocket(listenPort, 50, addr);
        }
        catch (IOException exc) {
            throw new AgentStartException("Failed to setup listen socket: " + exc.getMessage());
        }
    }

    @Override
    public void cleanup() {
        if (this.listenSock != null) {
            this.log.info((Object)("closing listener socket " + this.listenSock.getInetAddress() + ":" + this.listenSock.getLocalPort()));
            try {
                this.listenSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listenSock = null;
        }
    }

    @Override
    public AgentServerConnection getNewConnection() throws AgentConnectionException, InterruptedIOException {
        Socket conn;
        try {
            conn = this.listenSock.accept();
        }
        catch (InterruptedIOException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new AgentConnectionException("There was an error accepting the socket: " + exc.getMessage(), (Exception)exc);
        }
        return new DefaultServerConnection(conn);
    }
}

