/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.hyperic.hq.bizapp.agent.TokenData;
import org.hyperic.hq.bizapp.agent.TokenNotFoundException;
import org.hyperic.hq.bizapp.agent.TokenStorer;

public class TokenManager {
    private static final String PROP_PREFIX = "tokenData.";
    private static final String PROP_NUMTOKENS = "tokenData.numTokens";
    private static final String TOKEN_LOCKED = "locked";
    private static final String TOKEN_PENDING = "pending";
    private TokenStorer storer;
    private Set tokens = TokenManager.createSet();
    private long timeout;

    private static Set createSet() {
        return Collections.synchronizedSet(new HashSet());
    }

    public TokenManager(long timeout, TokenStorer storer) {
        this.timeout = timeout;
        this.storer = storer;
    }

    public void addToken(TokenData newToken) {
        this.tokens.add(newToken);
    }

    public void deleteToken(TokenData token) throws TokenNotFoundException {
        if (!this.tokens.remove(token)) {
            throw new TokenNotFoundException("Token '" + token + "' not found");
        }
    }

    public void setTokenLocked(TokenData token, boolean locked) throws TokenNotFoundException {
        if (!this.tokens.contains(token)) {
            throw new TokenNotFoundException("Token '" + token + "' not found");
        }
        this.deleteToken(token);
        TokenData tData = (TokenData)token.clone();
        tData.setLocked(locked);
        this.tokens.add(tData);
    }

    public List getTokens() {
        ArrayList<TokenData> res = new ArrayList<TokenData>();
        for (TokenData tData : this.tokens) {
            res.add(tData);
        }
        return res;
    }

    public TokenData getToken(String token) throws TokenNotFoundException {
        for (TokenData tData : this.tokens) {
            if (!tData.getToken().equals(token)) continue;
            return (TokenData)tData.clone();
        }
        throw new TokenNotFoundException("Token not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        Properties props = this.encodeTokens(this.tokens);
        OutputStream os = this.storer.getTokenStoreStream();
        try {
            props.store(os, "TokenManager authentication tokens");
            os.flush();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void load(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        this.tokens = this.decodeTokens(props);
    }

    private void outdateList() {
        Iterator i = this.tokens.iterator();
        while (i.hasNext()) {
            TokenData tData = (TokenData)i.next();
            if (tData.isLocked() || !this.tokenIsOutdated(tData.getCreateTime())) continue;
            i.remove();
        }
    }

    private boolean tokenIsOutdated(long createTime) {
        return createTime + this.timeout < System.currentTimeMillis();
    }

    private Set decodeTokens(Properties props) throws IOException {
        int numTokens;
        try {
            numTokens = Integer.parseInt(props.getProperty(PROP_NUMTOKENS));
        }
        catch (NumberFormatException exc) {
            throw new IOException("Unable to locate tokenData.numTokens in properties");
        }
        Set res = TokenManager.createSet();
        for (int i = 0; i < numTokens; ++i) {
            boolean locked;
            long createTime;
            String val = props.getProperty(PROP_PREFIX + i);
            if (val == null) {
                throw new IOException("Unable to find tokenData." + i);
            }
            StringTokenizer st = new StringTokenizer(val, ":");
            if (st.countTokens() != 3) {
                throw new IOException("Malformed token entry: " + val);
            }
            String token = st.nextToken();
            try {
                createTime = Long.parseLong(st.nextToken());
            }
            catch (NumberFormatException exc) {
                throw new IOException("Unable to parse token length(" + i + ")");
            }
            String sLocked = st.nextToken();
            if (sLocked.equals(TOKEN_PENDING)) {
                locked = false;
            } else if (sLocked.equals(TOKEN_LOCKED)) {
                locked = true;
            } else {
                throw new IOException("Unable to parse token locked(" + i + ")");
            }
            res.add(new TokenData(token, createTime, locked));
        }
        return res;
    }

    private Properties encodeTokens(Set tokens) {
        Properties res = new Properties();
        int idx = 0;
        for (TokenData tData : tokens) {
            String token = tData.getToken();
            if (token.indexOf(":") != -1) {
                throw new IllegalArgumentException("Unable to encode tokens containing the char ':': " + token);
            }
            String val = tData.getToken() + ":" + tData.getCreateTime() + ":" + (tData.isLocked() ? TOKEN_LOCKED : TOKEN_PENDING);
            res.setProperty(PROP_PREFIX + idx, val);
            ++idx;
        }
        res.setProperty(PROP_NUMTOKENS, Integer.toString(idx));
        return res;
    }
}

