/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.hyperic.hq.bizapp.agent.TokenData;
import org.hyperic.hq.bizapp.agent.TokenManager;
import org.hyperic.hq.bizapp.agent.TokenStorer;

public class AgentClientUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalAuthToken(String tokenFile) throws FileNotFoundException, IOException {
        List tokens;
        int nTries = 20;
        TokenManager tm = new TokenManager(1000000L, null);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(tokenFile);
            tm.load(fileInputStream);
            tokens = tm.getTokens();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (tokens.size() == 0) {
            throw new IOException("Token file contains no valid tokens");
        }
        return ((TokenData)tokens.get(0)).getToken();
    }

    public static void generateNewTokenFile(String tokenFile, String firstToken) throws IOException {
        TokenManager tm = new TokenManager(1000000L, new MyStorer(tokenFile));
        tm.addToken(new TokenData(firstToken, System.currentTimeMillis(), true));
        tm.store();
    }

    private static class MyStorer
    implements TokenStorer {
        private String tokenFile;

        private MyStorer() {
        }

        public MyStorer(String tokenFile) {
            this.tokenFile = tokenFile;
        }

        @Override
        public OutputStream getTokenStoreStream() throws IOException {
            return new FileOutputStream(this.tokenFile);
        }
    }
}

