/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.util.Collection;

abstract class StrongBase {
    private Class m_classCollection;
    private Class m_classObject;

    protected StrongBase() {
    }

    protected StrongBase(Class c, Class obj) {
        if (c == null || obj == null) {
            throw new IllegalArgumentException("Null pointer passed to the org.hyperic.util.StrongBase constructor.");
        }
        this.init(c, obj);
    }

    protected StrongBase(String c, String obj) throws ClassNotFoundException {
        this.init(Class.forName(c), Class.forName(obj));
    }

    protected void init(Class coll, Class obj) {
        if (coll == null || obj == null) {
            throw new IllegalArgumentException("Null pointer passed to the org.hyperic.util.StrongBase constructor.");
        }
        this.m_classCollection = coll;
        this.m_classObject = obj;
    }

    protected void init(String coll, String obj) throws ClassNotFoundException {
        this.init(Class.forName(coll), Class.forName(obj));
    }

    protected void checkCollection(Collection collection) {
        if (!this.isValidCollection(collection)) {
            throw new ClassCastException("A Java Collection of type " + collection + "was passed to a org.hyperic.util.Collection that accepts type " + this.m_classCollection);
        }
    }

    protected void checkObject(Object obj) {
        if (!this.isValidObject(obj)) {
            throw new ClassCastException("A Java Class of type " + obj.getClass() + " was passed to a " + this.m_classCollection + " that accepts type " + this.m_classObject);
        }
    }

    protected Class getCollectionClass() {
        return this.m_classCollection;
    }

    protected Class getObjectClass() {
        return this.m_classObject;
    }

    protected boolean isValidCollection(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("A null pointer was passed to a method that does not accept null paramaters.");
        }
        boolean bResult = this.m_classCollection.isInstance(collection);
        return bResult;
    }

    protected boolean isValidObject(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A null pointer was passed to a method that does not accept null paramaters.");
        }
        boolean bResult = this.m_classObject.isInstance(obj);
        return bResult;
    }
}

