/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.PrintStream;
import org.hyperic.util.PrintfFormat;
import org.hyperic.util.StringUtil;

public class TextProgressBar {
    private PrintStream out;
    private PrintfFormat printf;
    private String erase = null;
    private String name;
    private long current;
    private long total;
    private long startTime;
    private long refresh;
    private long lastUpdate;
    private boolean isComplete = false;
    private static final int NAME_LEN = 20;
    private static final String fmt = "%-20s | %+8s kB | %4.2f kB/s | ETA: %-10s | %3d %%";

    public TextProgressBar(PrintStream out, String name, long total) {
        this.out = out;
        this.total = total;
        this.name = name;
        this.current = 0L;
        this.lastUpdate = 0L;
        this.refresh = 1000L;
        this.startTime = System.currentTimeMillis() - 1L;
        this.printf = new PrintfFormat(fmt);
    }

    public void setRefresh(long refresh) {
        this.refresh = refresh;
    }

    public void update(long current) {
        this.current = current;
    }

    public void print(long current) {
        this.current = current;
        this.print();
    }

    public void print() {
        String timeLeft;
        if (this.isComplete) {
            return;
        }
        Long total = new Long(this.current / 1024L);
        Integer percent = new Integer((int)(this.current * 100L / this.total));
        long now = System.currentTimeMillis();
        if (percent < 100 && now - this.lastUpdate < this.refresh) {
            return;
        }
        long elapsed = now - this.startTime;
        Double rate = new Double(this.current / (elapsed * 1024L / 1000L));
        if (rate.longValue() == 0L) {
            timeLeft = "N/A";
        } else {
            long remain = (this.total - this.current) / rate.longValue();
            timeLeft = StringUtil.formatDuration(remain);
        }
        String filename = this.name.length() > 20 ? this.name.substring(0, 20) : this.name;
        Object[] args = new Object[]{filename, total.toString(), rate, timeLeft, percent};
        String status = this.printf.sprintf(args);
        if (this.erase == null) {
            this.out.print(status);
            this.erase = StringUtil.repeatChars('\b', status.length());
        } else {
            this.out.print(this.erase);
            if (percent == 100) {
                this.out.println(status);
                this.isComplete = true;
            } else {
                this.out.print(status);
            }
            this.erase = StringUtil.repeatChars('\b', status.length());
        }
        this.lastUpdate = now;
    }

    public static void main(String[] args) throws Exception {
        String name = "test.jar";
        long size = 0x200000L;
        System.out.println("Transferring " + name);
        TextProgressBar progress = new TextProgressBar(System.out, name, size);
        int i = 0;
        while ((long)i <= size) {
            Thread.sleep(10L);
            progress.print(i);
            i += 8192;
        }
        progress.print(i);
        System.out.println("Done");
    }
}

