/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.hyperic.util.config.InvalidOptionValueException;

public abstract class ConfigOption
implements Serializable,
Cloneable {
    private String optName;
    private String optDesc;
    private String optCat;
    private String optPlatform;
    private String defValue;
    private String confirm = null;
    private Boolean optional;
    private Boolean readonly = false;
    private Boolean advanced = null;

    public ConfigOption() {
    }

    public ConfigOption(String optName, String optDesc, String defValue) {
        if (optName == null || optDesc == null) {
            throw new IllegalArgumentException();
        }
        this.optName = optName;
        this.optDesc = optDesc;
        this.defValue = defValue;
        this.optional = Boolean.FALSE;
    }

    public ConfigOption copy() throws CloneNotSupportedException {
        return (ConfigOption)this.clone();
    }

    public abstract void checkOptionIsValid(String var1) throws InvalidOptionValueException;

    protected InvalidOptionValueException invalidOption(String msg) {
        return new InvalidOptionValueException(this.getName() + " " + msg);
    }

    public void setDefault(String value) {
        this.defValue = value;
    }

    public String getDefault() {
        return this.defValue;
    }

    public void setOptional(boolean optional) {
        this.optional = optional ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setAdvanced(Boolean advanced) {
        this.advanced = advanced;
    }

    public Boolean isAdvanced() {
        return this.advanced;
    }

    public void setName(String name) {
        this.optName = name;
    }

    public String getName() {
        return this.optName;
    }

    public void setDescription(String description) {
        this.optDesc = description;
    }

    public String getDescription() {
        return this.optDesc;
    }

    public void setCategory(String category) {
        this.optCat = category;
    }

    public String getCategory() {
        return this.optCat;
    }

    public String getPlatform() {
        return this.optPlatform;
    }

    public void setPlatform(String platform) {
        this.optPlatform = platform;
        if (StringUtils.isNotBlank((String)platform)) {
            this.setOptional(true);
        }
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigOption)) {
            return false;
        }
        return ((ConfigOption)obj).getName().equals(this.getName());
    }

    public String toString() {
        return "[ConfigOption name=" + this.getName() + "]";
    }
}

